/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.notifications.types;

import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.SingleLineTaxableNotification;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxableNotification;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class FluidTradeNotification
extends SingleLineTaxableNotification {
    public static final NotificationType<FluidTradeNotification> TYPE = new NotificationType(ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"fluid_trade"), FluidTradeNotification::new);
    TraderCategory traderData;
    TradeDirection tradeType;
    Component fluidName;
    int fluidCount;
    MoneyValue cost = MoneyValue.empty();
    String customer;

    private FluidTradeNotification() {
    }

    protected FluidTradeNotification(FluidTradeData trade, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.tradeType = trade.getTradeDirection();
        this.fluidName = FluidFormatUtil.getFluidName(trade.getProduct()).withStyle(Style.EMPTY);
        this.fluidCount = trade.getQuantity();
        this.cost = cost;
        this.customer = customer.getName(false);
    }

    public static Supplier<Notification> create(FluidTradeData trade, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        return () -> new FluidTradeNotification(trade, cost, customer, traderData, taxesPaid);
    }

    @Nonnull
    protected NotificationType<FluidTradeNotification> getType() {
        return TYPE;
    }

    @Nonnull
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Nonnull
    public MutableComponent getNormalMessage() {
        MutableComponent boughtText = this.tradeType.getActionPhrase();
        MutableComponent fluidText = TechText.NOTIFICATION_FLUID_FORMAT.get(new Object[]{FluidFormatUtil.formatFluidAmount(this.fluidCount), this.fluidName});
        MutableComponent cost = this.cost.getText("0");
        return TechText.NOTIFICATION_TRADE_FLUID.get(new Object[]{this.customer, boughtText, fluidText, cost});
    }

    protected void saveNormal(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.put("TraderInfo", (Tag)this.traderData.save(lookup));
        compound.putInt("TradeType", this.tradeType.index);
        compound.putString("Fluid", Component.Serializer.toJson((Component)this.fluidName, (HolderLookup.Provider)lookup));
        compound.putInt("FluidCount", this.fluidCount);
        compound.put("Price", (Tag)this.cost.save());
        compound.putString("Customer", this.customer);
    }

    protected void loadNormal(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.traderData = new TraderCategory(compound.getCompound("TraderInfo"), lookup);
        this.tradeType = TradeDirection.fromIndex((int)compound.getInt("TradeType"));
        this.fluidName = Component.Serializer.fromJson((String)compound.getString("Fluid"), (HolderLookup.Provider)lookup);
        this.fluidCount = compound.getInt("FluidCount");
        this.cost = MoneyValue.safeLoad((CompoundTag)compound, (String)"Price");
        this.customer = compound.getString("Customer");
    }

    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof FluidTradeNotification) {
            FluidTradeNotification ftn = (FluidTradeNotification)other;
            if (!ftn.traderData.matches((NotificationCategory)this.traderData)) {
                return false;
            }
            if (ftn.tradeType != this.tradeType) {
                return false;
            }
            if (!ftn.fluidName.getString().equals(this.fluidName.getString())) {
                return false;
            }
            if (ftn.fluidCount != this.fluidCount) {
                return false;
            }
            if (!ftn.cost.equals((Object)this.cost)) {
                return false;
            }
            if (!ftn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch((TaxableNotification)ftn);
        }
        return false;
    }
}

