/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.energy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.client.gui.settings.energy.EnergyInputAddon;
import io.github.lightman314.lctech.common.core.ModItems;
import io.github.lightman314.lctech.common.items.IBatteryItem;
import io.github.lightman314.lctech.common.menu.traderstorage.energy.EnergyStorageTab;
import io.github.lightman314.lctech.common.menu.traderstorage.energy.EnergyTradeEditTab;
import io.github.lightman314.lctech.common.notifications.types.EnergyTradeNotification;
import io.github.lightman314.lctech.common.traders.energy.EnergyInteractionSlot;
import io.github.lightman314.lctech.common.traders.energy.TradeEnergyHandler;
import io.github.lightman314.lctech.common.traders.energy.settings.EnergyTradeSettings;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.upgrades.TechUpgradeTypes;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.stats.StatKeys;
import io.github.lightman314.lightmanscurrency.api.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.input.InputTabAddon;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergyTraderData
extends InputTraderData {
    public static final int DEFAULT_TRADE_LIMIT = 8;
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{TechUpgradeTypes.ENERGY_CAPACITY});
    public static final TraderType<EnergyTraderData> TYPE = new TraderType(ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"energy_trader"), EnergyTraderData::new);
    protected final TradeEnergyHandler energyHandler = new TradeEnergyHandler(this);
    private DrainMode drainMode = DrainMode.PURCHASES_ONLY;
    List<EnergyTradeData> trades = EnergyTradeData.listOfSize(1, true);
    int energyStorage = 0;
    int pendingDrain = 0;

    public final boolean drainCapable() {
        return !this.showOnTerminal();
    }

    protected boolean allowVoidUpgrade() {
        return true;
    }

    public DrainMode getDrainMode() {
        return this.drainMode;
    }

    public boolean isAlwaysDrainMode() {
        return !this.drainCapable() || this.drainMode == DrainMode.ALWAYS;
    }

    public boolean isPurchaseDrainMode() {
        if (!this.drainCapable()) {
            return false;
        }
        if (this.drainMode == DrainMode.PURCHASES_ONLY) {
            for (Direction side : Direction.values()) {
                if (!this.allowOutputSide(side)) continue;
                return true;
            }
        }
        return false;
    }

    private EnergyTraderData() {
        super(TYPE);
    }

    public EnergyTraderData(Level level, BlockPos pos) {
        super(TYPE, level, pos);
    }

    public List<TradeDirection> validDirectionOptions() {
        return ImmutableList.of((Object)TradeDirection.SALE, (Object)TradeDirection.PURCHASE);
    }

    protected void registerNodes(Consumer<SettingsNode> builder) {
        super.registerNodes(builder);
        builder.accept((SettingsNode)new EnergyTradeSettings(this));
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        super.saveAdditional(compound, lookup);
        this.saveTrades(compound, lookup);
        this.saveEnergyStorage(compound);
        this.saveDrainMode(compound);
    }

    protected final void saveTrades(CompoundTag compound, HolderLookup.Provider lookup) {
        EnergyTradeData.WriteNBTList(this.trades, compound, lookup);
    }

    protected final void saveDrainMode(CompoundTag compound) {
        compound.putInt("DrainMode", this.drainMode.index);
    }

    protected final void saveEnergyStorage(CompoundTag compound) {
        compound.putInt("Battery", this.energyStorage);
        compound.putInt("PendingDrain", this.pendingDrain);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        super.loadAdditional(compound, lookup);
        if (compound.contains("Trades")) {
            this.trades = EnergyTradeData.LoadNBTList(compound, !this.isPersistent(), lookup);
        }
        if (compound.contains("Battery")) {
            this.energyStorage = Math.max(0, compound.getInt("Battery"));
        }
        if (compound.contains("PendingDrain")) {
            this.pendingDrain = Math.max(0, compound.getInt("PendingDrain"));
        }
        if (compound.contains("DrainMode")) {
            this.drainMode = DrainMode.of(compound.getInt("DrainMode"));
        }
    }

    public int getTradeCount() {
        return this.trades.size();
    }

    public EnergyTradeData getTrade(int tradeIndex) {
        if (tradeIndex >= 0 && tradeIndex < this.trades.size()) {
            return this.trades.get(tradeIndex);
        }
        return new EnergyTradeData(false);
    }

    public List<EnergyTradeData> getTradeData() {
        return new ArrayList<EnergyTradeData>(this.trades);
    }

    public TradeEnergyHandler getEnergyHandler() {
        return this.energyHandler;
    }

    public boolean canEditTradeCount() {
        return true;
    }

    public int getMaxTradeCount() {
        return 8;
    }

    public void addTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() >= 100) {
            return;
        }
        if (this.getTradeCount() >= 8 && !LCAdminMode.isAdminPlayer((Player)requestor)) {
            Permissions.PermissionWarning((Player)requestor, (String)"add creative trade slot", (String)"LC_ADMIN_MODE");
            return;
        }
        if (!this.hasPermission(requestor, "editTrades")) {
            Permissions.PermissionWarning((Player)requestor, (String)"add trade slot", (String)"editTrades");
            return;
        }
        this.overrideTradeCount(this.getTradeCount() + 1);
    }

    public void removeTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() <= 1) {
            return;
        }
        if (!this.hasPermission(requestor, "editTrades")) {
            Permissions.PermissionWarning((Player)requestor, (String)"remove trade slot", (String)"editTrades");
            return;
        }
        this.overrideTradeCount(this.getTradeCount() - 1);
    }

    public void overrideTradeCount(int newTradeCount) {
        if (this.getTradeCount() == newTradeCount) {
            return;
        }
        int tradeCount = MathUtil.clamp((int)newTradeCount, (int)1, (int)100);
        List<EnergyTradeData> oldTrades = this.trades;
        this.trades = EnergyTradeData.listOfSize(tradeCount, !this.isPersistent());
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        if (this.isServer()) {
            this.markDirty(this::saveTrades);
        }
    }

    public int getTradeStock(int tradeIndex) {
        return this.getTrade(tradeIndex).getStock(this);
    }

    public int getPendingDrain() {
        return Math.max(this.pendingDrain, 0);
    }

    private void setPendingDrain(int amount) {
        this.pendingDrain = Math.max(amount, 0);
    }

    public void addPendingDrain(int amount) {
        this.pendingDrain += amount;
    }

    public void shrinkPendingDrain(int amount) {
        this.setPendingDrain(this.pendingDrain - amount);
    }

    public int getAvailableEnergy() {
        return this.energyStorage - this.getPendingDrain();
    }

    public int getDrainableEnergy() {
        if (this.isAlwaysDrainMode()) {
            return this.isCreative() ? 0 : this.getAvailableEnergy();
        }
        if (this.isPurchaseDrainMode()) {
            return this.isCreative() ? this.pendingDrain : Math.min(this.pendingDrain, this.energyStorage);
        }
        return 0;
    }

    public int getTotalEnergy() {
        return this.energyStorage;
    }

    public static int getDefaultMaxEnergy() {
        return (Integer)TechConfig.SERVER.energyTraderDefaultStorage.get();
    }

    public int getMaxEnergy() {
        int defaultCapacity;
        int maxEnergy = defaultCapacity = EnergyTraderData.getDefaultMaxEnergy();
        boolean baseStorageCompensation = false;
        for (int i = 0; i < this.getUpgrades().getContainerSize(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || upgradeItem.getUpgradeType() != TechUpgradeTypes.ENERGY_CAPACITY) continue;
            int addAmount = UpgradeItem.getUpgradeData((ItemStack)stack).getIntValue(CapacityUpgrade.CAPACITY);
            if (addAmount > defaultCapacity && !baseStorageCompensation) {
                addAmount -= defaultCapacity;
                baseStorageCompensation = true;
            }
            maxEnergy += addAmount;
        }
        return maxEnergy;
    }

    public void shrinkEnergy(int amount) {
        this.energyStorage -= amount;
    }

    public void addEnergy(int amount) {
        this.energyStorage += amount;
    }

    public void markEnergyStorageDirty() {
        this.markDirty(this::saveEnergyStorage);
    }

    public IconData inputSettingsTabIcon() {
        return IconData.of((ItemStack)IBatteryItem.HideEnergyBar(ModItems.BATTERY));
    }

    public MutableComponent inputSettingsTabTooltip() {
        return TechText.TOOLTIP_SETTINGS_INPUT_ENERGY.get(new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<InputTabAddon> inputSettingsAddons() {
        return ImmutableList.of((Object)((Object)EnergyInputAddon.INSTANCE));
    }

    public void handleSettingsChange(Player player, LazyPacketData message) {
        DrainMode newMode;
        super.handleSettingsChange(player, message);
        if (message.contains("NewEnergyDrainMode") && this.drainMode != (newMode = DrainMode.of(message.getInt("NewEnergyDrainMode")))) {
            this.drainMode = newMode;
            this.markDirty(this::saveDrainMode);
        }
    }

    public TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        EnergyTradeData trade = this.getTrade(tradeIndex);
        if (trade == null || !trade.isValid()) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(trade, context).isCanceled()) {
            return TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        MoneyValue price = trade.getCost(context);
        if (!trade.hasStock(context) && !this.isCreative()) {
            return TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (trade.isSale()) {
            if (!(context.canFitEnergy(trade.getAmount()) || this.drainCapable() && this.hasOutputSide() && this.isPurchaseDrainMode())) {
                return TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.getPayment(price)) {
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            boolean drainStorage = true;
            if (context.canFitEnergy(trade.getAmount())) {
                context.fillEnergy(trade.getAmount());
            } else {
                this.addPendingDrain(trade.getAmount());
                drainStorage = false;
            }
            MoneyValue taxesPaid = MoneyValue.empty();
            if (this.canStoreMoney()) {
                taxesPaid = this.addStoredMoney(price, true);
            }
            if (!this.isCreative() && drainStorage) {
                this.shrinkEnergy(trade.getAmount());
                this.markEnergyStorageDirty();
            }
            this.incrementStat(StatKeys.Traders.MONEY_EARNED, price);
            if (!taxesPaid.isEmpty()) {
                this.incrementStat(StatKeys.Taxables.TAXES_PAID, taxesPaid);
            }
            this.pushNotification(EnergyTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(trade, context, price, taxesPaid);
            return TradeResult.SUCCESS;
        }
        if (trade.isPurchase()) {
            if (!context.hasEnergy(trade.getAmount())) {
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.isCreative()) {
                return TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!context.givePayment(price)) {
                return TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.drainEnergy(trade.getAmount())) {
                context.getPayment(price);
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            MoneyValue taxesPaid = MoneyValue.empty();
            if (this.shouldStoreGoods()) {
                this.addEnergy(trade.getAmount());
                this.markEnergyStorageDirty();
            }
            if (!this.isCreative()) {
                taxesPaid = this.removeStoredMoney(price, true);
            }
            this.incrementStat(StatKeys.Traders.MONEY_PAID, price);
            if (!taxesPaid.isEmpty()) {
                this.incrementStat(StatKeys.Taxables.TAXES_PAID, taxesPaid);
            }
            this.pushNotification(EnergyTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(trade, context, price, taxesPaid);
            return TradeResult.SUCCESS;
        }
        return TradeResult.FAIL_INVALID_TRADE;
    }

    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
        interactionSlots.add(EnergyInteractionSlot.INSTANCE);
    }

    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public boolean canMakePersistent() {
        return true;
    }

    protected void getAdditionalContents(List<ItemStack> contents) {
    }

    public IconData getIcon() {
        return IconData.of((ItemStack)IBatteryItem.HideEnergyBar((ItemLike)ModItems.BATTERY.get()));
    }

    public boolean hasValidTrade() {
        for (EnergyTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            return true;
        }
        return false;
    }

    public void initStorageTabs(ITraderStorageMenu menu) {
        menu.setTab(1, (TraderStorageTab)new EnergyStorageTab(menu));
        menu.setTab(2, (TraderStorageTab)new EnergyTradeEditTab(menu));
    }

    protected void loadAdditionalFromJson(JsonObject json, HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        JsonArray tradeList = GsonHelper.getAsJsonArray((JsonObject)json, (String)"Trades");
        this.trades = new ArrayList<EnergyTradeData>();
        for (int i = 0; i < tradeList.size() && this.trades.size() < 100; ++i) {
            try {
                JsonObject tradeData = GsonHelper.convertToJsonObject((JsonElement)tradeList.get(i), (String)("Trades[" + i + "]"));
                EnergyTradeData newTrade = new EnergyTradeData(false);
                if (tradeData.has("TradeType")) {
                    newTrade.setTradeDirection(EnergyTradeData.loadTradeType(GsonHelper.getAsString((JsonObject)tradeData, (String)"TradeType")));
                }
                newTrade.setAmount(GsonHelper.getAsInt((JsonObject)tradeData, (String)"Quantity"));
                newTrade.setCost(MoneyValue.loadFromJson((JsonElement)tradeData.get("Price")));
                if (tradeData.has("TradeRules")) {
                    newTrade.setRules(TradeRule.Parse((JsonArray)GsonHelper.getAsJsonArray((JsonObject)tradeData, (String)"TradeRules"), (ITradeRuleHost)newTrade, (HolderLookup.Provider)lookup));
                }
                this.trades.add(newTrade);
                continue;
            }
            catch (JsonSyntaxException | ResourceLocationException e) {
                LCTech.LOGGER.error("Error parsing energy trade at index {}", (Object)i, (Object)e);
            }
        }
        if (this.trades.isEmpty()) {
            throw new JsonSyntaxException("Trader has no valid trades!");
        }
        this.energyStorage = this.getMaxEnergy();
    }

    protected void saveAdditionalToJson(JsonObject json, HolderLookup.Provider lookup) {
        JsonArray trades = new JsonArray();
        for (EnergyTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            tradeData.addProperty("TradeType", trade.getTradeDirection().name());
            tradeData.add("Price", (JsonElement)trade.getCost().toJson());
            tradeData.addProperty("Quantity", (Number)trade.getAmount());
            if (!trade.getRules().isEmpty()) {
                tradeData.add("TradeRules", (JsonElement)TradeRule.saveRulesToJson((List)trade.getRules(), (HolderLookup.Provider)lookup));
            }
            trades.add((JsonElement)tradeData);
        }
        json.add("Trades", (JsonElement)trades);
    }

    protected void saveAdditionalPersistentData(CompoundTag compound, HolderLookup.Provider lookup) {
        ListTag tradePersistentData = new ListTag();
        boolean tradesAreRelevant = false;
        Iterator<EnergyTradeData> iterator = this.trades.iterator();
        while (iterator.hasNext()) {
            CompoundTag ptTag = new CompoundTag();
            EnergyTradeData trade = iterator.next();
            if (TradeRule.savePersistentData((CompoundTag)ptTag, (List)trade.getRules(), (String)"RuleData", (HolderLookup.Provider)lookup)) {
                tradesAreRelevant = true;
            }
            tradePersistentData.add((Object)ptTag);
        }
        if (tradesAreRelevant) {
            compound.put("PersistentTradeData", (Tag)tradePersistentData);
        }
    }

    protected void loadAdditionalPersistentData(CompoundTag compound, HolderLookup.Provider lookup) {
        if (compound.contains("PersistentTradeData")) {
            ListTag tradePersistentData = compound.getList("PersistentTradeData", 10);
            for (int i = 0; i < tradePersistentData.size() && i < this.trades.size(); ++i) {
                EnergyTradeData trade = this.trades.get(i);
                CompoundTag ptTag = tradePersistentData.getCompound(i);
                TradeRule.loadPersistentData((CompoundTag)ptTag, (List)trade.getRules(), (String)"RuleData", (HolderLookup.Provider)lookup);
            }
        }
    }

    public static List<Component> getEnergyHoverTooltip(EnergyTraderData trader) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(Component.literal((String)(EnergyUtil.formatEnergyAmount(trader.getTotalEnergy()) + "/" + EnergyUtil.formatEnergyAmount(trader.getMaxEnergy()))).withStyle(ChatFormatting.AQUA));
        if (trader.getPendingDrain() > 0) {
            tooltip.add(TechText.TOOLTIP_ENERGY_PENDING_DRAIN.get(new Object[]{EnergyUtil.formatEnergyAmount(trader.getPendingDrain())}).withStyle(ChatFormatting.AQUA));
        }
        return tooltip;
    }

    public final boolean canDrainExternally() {
        return this.drainCapable() && this.hasOutputSide();
    }

    protected void appendTerminalInfo(List<Component> list, @Nullable Player player) {
        int tradeCount = 0;
        int outOfStock = 0;
        for (EnergyTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            ++tradeCount;
            if (this.isCreative() || trade.hasStock(this)) continue;
            ++outOfStock;
        }
        list.add((Component)LCText.TOOLTIP_NETWORK_TERMINAL_TRADE_COUNT.get(new Object[]{tradeCount}));
        if (outOfStock > 0) {
            list.add((Component)LCText.TOOLTIP_NETWORK_TERMINAL_OUT_OF_STOCK_COUNT.get(new Object[]{outOfStock}));
        }
    }

    public static enum DrainMode {
        ALWAYS(0),
        PURCHASES_ONLY(1);

        public final int index;

        private DrainMode(int index) {
            this.index = index;
        }

        public static DrainMode of(int index) {
            for (DrainMode mode : DrainMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return ALWAYS;
        }
    }
}

