/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.energy;

import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TradeEnergyHandler {
    final EnergyTraderData trader;
    final Map<Direction, IEnergyStorage> externalHandlers = new HashMap<Direction, IEnergyStorage>();
    final IEnergyStorage batteryInteractable;

    public TradeEnergyHandler(EnergyTraderData trader) {
        this.trader = trader;
        this.batteryInteractable = new BatteryInteractionEnergyHandler(trader);
    }

    public IEnergyStorage getExternalHandler(Direction relativeDirection) {
        if (!this.externalHandlers.containsKey(relativeDirection)) {
            this.externalHandlers.put(relativeDirection, new ExternalEnergyHandler(this.trader, relativeDirection));
        }
        return this.externalHandlers.get(relativeDirection);
    }

    private record BatteryInteractionEnergyHandler(EnergyTraderData trader) implements IEnergyStorage
    {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int receiveAmount = Math.min(maxReceive, this.trader.getMaxEnergy() - this.trader.getTotalEnergy());
            if (!simulate) {
                this.trader.addEnergy(receiveAmount);
                this.trader.markEnergyStorageDirty();
            }
            return receiveAmount;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extractAmount = Math.min(maxExtract, this.trader.getAvailableEnergy());
            if (!simulate) {
                this.trader.shrinkEnergy(extractAmount);
                this.trader.markEnergyStorageDirty();
            }
            return extractAmount;
        }

        public int getEnergyStored() {
            return this.trader.getAvailableEnergy();
        }

        public int getMaxEnergyStored() {
            return this.trader.getMaxEnergy();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }

    public static class ExternalEnergyHandler
    implements IEnergyStorage {
        protected final EnergyTraderData trader;
        protected final Direction relativeDirection;

        public final boolean isCreative() {
            return this.trader.isCreative();
        }

        public ExternalEnergyHandler(EnergyTraderData trader, Direction relativeDirection) {
            this.trader = trader;
            this.relativeDirection = relativeDirection;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int receiveAmount = Math.min(maxReceive, Math.max(0, this.trader.getMaxEnergy() - this.trader.getTotalEnergy()));
            if (!simulate && receiveAmount > 0) {
                this.trader.addEnergy(receiveAmount);
                this.trader.markEnergyStorageDirty();
            }
            return receiveAmount;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int extractAmount = Math.min(maxExtract, this.trader.getDrainableEnergy());
            if (!simulate && extractAmount > 0) {
                if (!this.isCreative()) {
                    this.trader.shrinkEnergy(extractAmount);
                }
                if (this.trader.isPurchaseDrainMode()) {
                    this.trader.shrinkPendingDrain(extractAmount);
                }
                this.trader.markEnergyStorageDirty();
            }
            return extractAmount;
        }

        public int getEnergyStored() {
            return this.trader.getTotalEnergy();
        }

        public int getMaxEnergyStored() {
            return this.trader.getMaxEnergy();
        }

        public boolean canExtract() {
            return this.trader.allowOutputSide(this.relativeDirection);
        }

        public boolean canReceive() {
            return this.trader.allowInputSide(this.relativeDirection);
        }
    }
}

