/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid;

import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TradeFluidHandler {
    final FluidTraderData trader;
    Map<Direction, ExternalFluidHandler> externalHandlers = new HashMap<Direction, ExternalFluidHandler>();

    public TradeFluidHandler(FluidTraderData trader) {
        this.trader = trader;
    }

    public IFluidHandler getExternalHandler(Direction relativeDirection) {
        if (!this.externalHandlers.containsKey(relativeDirection)) {
            this.externalHandlers.put(relativeDirection, new ExternalFluidHandler(this.trader, relativeDirection));
        }
        return this.externalHandlers.get(relativeDirection);
    }

    public static class ExternalFluidHandler
    implements IFluidHandler {
        protected final FluidTraderData trader;
        protected final Direction relativeDirection;

        protected ExternalFluidHandler(FluidTraderData trader, Direction relativeDirection) {
            this.trader = trader;
            this.relativeDirection = relativeDirection;
        }

        public final boolean isCreative() {
            return this.trader.isCreative();
        }

        public final TraderFluidStorage.FluidEntry getTankEntry(FluidStack fluid) {
            return this.trader.getStorage().getTank(fluid);
        }

        public final TraderFluidStorage.FluidEntry getTankEntry(int tank) {
            return tank < 0 || tank >= this.trader.getStorage().getContents().size() ? null : this.trader.getStorage().getContents().get(tank);
        }

        public final void markStorageDirty() {
            this.trader.getStorage().clearInvalidTanks();
            this.trader.markStorageDirty();
        }

        public TraderFluidStorage.FluidEntry getValidDrainTank(FluidStack resource) {
            for (TraderFluidStorage.FluidEntry entry : this.trader.getStorage().getContents()) {
                if (entry.filter.isEmpty()) continue;
                if (entry.hasPendingDrain() && (FluidStack.isSameFluidSameComponents((FluidStack)entry.filter, (FluidStack)resource) || resource.isEmpty())) {
                    return entry;
                }
                if (!this.allowAutoDraining(entry.filter) || !entry.drainable) continue;
                return entry;
            }
            return null;
        }

        private boolean allowAutoDraining(FluidStack fluid) {
            if (fluid.isEmpty()) {
                return false;
            }
            for (int i = 0; i < this.trader.getTradeCount(); ++i) {
                FluidTradeData trade = this.trader.getTrade(i);
                if (!trade.isSale() || !FluidStack.isSameFluidSameComponents((FluidStack)trade.getProduct(), (FluidStack)fluid)) continue;
                return false;
            }
            return true;
        }

        public int getTanks() {
            return this.trader.getStorage().getContents().size();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (tank >= 0 && tank < this.trader.getStorage().getContents().size()) {
                return this.trader.getStorage().getContents().get(tank).getTankContents();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return this.trader.getTankCapacity();
        }

        protected final boolean cannotFill() {
            return !this.trader.allowInputSide(this.relativeDirection);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            if (this.cannotFill()) {
                return false;
            }
            TraderFluidStorage.FluidEntry entry = this.getTankEntry(tank);
            if (entry == null) {
                return false;
            }
            return entry.fillable && FluidStack.isSameFluidSameComponents((FluidStack)entry.filter, (FluidStack)stack);
        }

        public int fill(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
            if (this.cannotFill()) {
                return 0;
            }
            TraderFluidStorage.FluidEntry tank = this.getTankEntry(resource);
            if (tank != null) {
                int fillAmount = MathUtil.clamp((int)resource.getAmount(), (int)0, (int)this.trader.getStorage().getFillableAmount(resource));
                if (action.execute()) {
                    tank.addAmount(fillAmount);
                    this.markStorageDirty();
                }
                return fillAmount;
            }
            return 0;
        }

        protected final boolean cannotDrain() {
            return !this.trader.allowOutputSide(this.relativeDirection);
        }

        @Nonnull
        public FluidStack drain(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
            if (this.cannotDrain()) {
                return FluidStack.EMPTY;
            }
            if (resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            TraderFluidStorage.FluidEntry tank = this.getValidDrainTank(resource);
            if (tank != null) {
                int drainAmount = tank.hasPendingDrain() ? Math.min(resource.getAmount(), this.isCreative() ? tank.getPendingDrain() : Math.min(tank.getPendingDrain(), tank.getStoredAmount())) : Math.min(resource.getAmount(), tank.getTankContents().getAmount());
                FluidStack returnStack = tank.filter.copy();
                returnStack.setAmount(drainAmount);
                if (action.execute()) {
                    if (!this.isCreative()) {
                        tank.removeAmount(drainAmount);
                    }
                    if (tank.hasPendingDrain()) {
                        tank.removePendingDrain(drainAmount);
                    }
                    this.markStorageDirty();
                }
                return returnStack;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, @Nonnull IFluidHandler.FluidAction action) {
            if (this.cannotDrain()) {
                return FluidStack.EMPTY;
            }
            TraderFluidStorage.FluidEntry tank = this.getValidDrainTank(FluidStack.EMPTY);
            if (tank != null) {
                int drainAmount = tank.hasPendingDrain() ? Math.min(maxDrain, this.isCreative() ? tank.getPendingDrain() : Math.min(tank.getPendingDrain(), tank.getTankContents().getAmount())) : Math.min(maxDrain, tank.getTankContents().getAmount());
                FluidStack returnStack = tank.filter.copy();
                returnStack.setAmount(drainAmount);
                if (action.execute()) {
                    if (!this.isCreative()) {
                        tank.removeAmount(drainAmount);
                    }
                    if (tank.hasPendingDrain()) {
                        tank.removePendingDrain(drainAmount);
                    }
                    this.markStorageDirty();
                }
                return returnStack;
            }
            return FluidStack.EMPTY;
        }
    }
}

