/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TraderFluidStorage
implements IFluidHandler {
    private final ITraderFluidFilter filter;
    List<FluidEntry> tanks = new ArrayList<FluidEntry>();

    public List<FluidEntry> getContents() {
        return this.tanks;
    }

    public TraderFluidStorage(ITraderFluidFilter filter) {
        this.filter = filter;
    }

    public void save(CompoundTag compound, String tag, @Nonnull HolderLookup.Provider lookup) {
        ListTag list = new ListTag();
        for (FluidEntry tank : this.tanks) {
            if (tank.filter.isEmpty()) continue;
            CompoundTag fluidTag = new CompoundTag();
            tank.save(fluidTag, lookup);
            list.add((Object)fluidTag);
        }
        compound.put(tag, (Tag)list);
    }

    public void load(CompoundTag compound, String tag, @Nonnull HolderLookup.Provider lookup) {
        if (compound.contains(tag, 9)) {
            ListTag list = compound.getList(tag, 10);
            this.tanks.clear();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag fluidTag = list.getCompound(i);
                FluidEntry tank = FluidEntry.load(this, fluidTag, lookup);
                if (tank.filter.isEmpty()) continue;
                this.tanks.add(tank);
            }
        }
        this.refactorTanks();
    }

    public boolean isDrainable(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        return entry != null && (entry.drainable || !this.allowFluid(entry.filter));
    }

    public int getActualFluidCount(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        if (entry != null) {
            return entry.getStoredAmount();
        }
        return 0;
    }

    public int getAvailableFluidCount(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        if (entry != null) {
            return entry.getStoredAmount() - entry.getPendingDrain();
        }
        return 0;
    }

    public int getPendingDrain(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        if (entry != null) {
            return entry.getPendingDrain();
        }
        return 0;
    }

    public FluidEntry getTank(FluidStack fluid) {
        for (FluidEntry entry : this.tanks) {
            if (!FluidStack.isSameFluidSameComponents((FluidStack)entry.filter, (FluidStack)fluid)) continue;
            return entry;
        }
        return null;
    }

    public int getFillableAmount(FluidStack fluid) {
        if (!this.allowFluid(fluid)) {
            return 0;
        }
        return Math.max(0, this.getTankCapacity() - this.getActualFluidCount(fluid));
    }

    public boolean allowFluid(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return false;
        }
        return this.filter.isFluidRelevant(fluid);
    }

    public boolean refactorTanks() {
        boolean result = false;
        for (FluidStack fluid : this.filter.getRelevantFluids()) {
            FluidEntry entry = this.getTank(fluid);
            if (entry != null) continue;
            FluidEntry newEntry = new FluidEntry(this, fluid, 0, 0, false, false);
            this.tanks.add(newEntry);
            result = true;
        }
        return this.clearInvalidTanks() || result;
    }

    public boolean clearInvalidTanks() {
        boolean result = false;
        for (int i = 0; i < this.tanks.size(); ++i) {
            FluidEntry entry = this.tanks.get(i);
            if (entry.filter.isEmpty()) {
                this.tanks.remove(i);
                --i;
                result = true;
                continue;
            }
            if (!entry.isEmpty() || this.allowFluid(entry.filter)) continue;
            this.tanks.remove(i);
            --i;
            result = true;
        }
        return result;
    }

    public void forceFillTank(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        FluidEntry entry = this.getTank(fluid);
        if (entry != null) {
            entry.addAmount(fluid.getAmount());
            return;
        }
        if (this.tanks.size() >= 8) {
            return;
        }
        this.tanks.add(new FluidEntry(this, fluid));
    }

    public void drain(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        if (entry == null) {
            return;
        }
        entry.removeAmount(fluid.getAmount());
    }

    public int getTanks() {
        return this.tanks.size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < this.tanks.size()) {
            return this.tanks.get(tank).getTankContents();
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return this.getTankCapacity();
    }

    public int getTankCapacity() {
        return this.filter.getTankCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank < 0 || tank >= this.tanks.size()) {
            return false;
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)this.tanks.get((int)tank).filter, (FluidStack)stack);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
        int drainableAmount = Math.min(resource.getAmount(), this.getAvailableFluidCount(resource));
        if (drainableAmount <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack drainedFluid = resource.copy();
        drainedFluid.setAmount(drainableAmount);
        if (action.execute()) {
            this.drain(drainedFluid);
        }
        return drainedFluid;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, @Nonnull IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public int fill(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
        if (!this.allowFluid(resource)) {
            return 0;
        }
        int fillAmount = Math.min(resource.getAmount(), this.getFillableAmount(resource));
        if (fillAmount > 0 && action.execute()) {
            FluidStack fillStack = resource.copy();
            fillStack.setAmount(fillAmount);
            this.forceFillTank(fillStack);
        }
        return fillAmount;
    }

    public static interface ITraderFluidFilter {
        default public boolean isFluidRelevant(FluidStack fluid) {
            for (FluidStack f : this.getRelevantFluids()) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)f, (FluidStack)fluid)) continue;
                return true;
            }
            return false;
        }

        public List<FluidStack> getRelevantFluids();

        public int getTankCapacity();
    }

    public static class FluidEntry
    implements IFluidHandler {
        private final TraderFluidStorage parent;
        public final FluidStack filter;
        private int storedAmount;
        private int pendingDrain = 0;
        public boolean drainable = false;
        public boolean fillable = false;

        public int getStoredAmount() {
            return this.storedAmount;
        }

        public boolean isEmpty() {
            return this.storedAmount <= 0;
        }

        public void addAmount(int amount) {
            this.storedAmount += amount;
        }

        public void setAmount(int amount) {
            this.storedAmount = amount;
        }

        public void removeAmount(int amount) {
            this.storedAmount -= amount;
        }

        public FluidStack getTankContents() {
            FluidStack fluid = this.filter.copy();
            if (!fluid.isEmpty()) {
                fluid.setAmount(this.storedAmount);
            }
            return fluid;
        }

        public int getPendingDrain() {
            return this.pendingDrain;
        }

        public boolean hasPendingDrain() {
            return this.pendingDrain > 0;
        }

        public void addPendingDrain(int amount) {
            this.pendingDrain += amount;
        }

        public void removePendingDrain(int amount) {
            this.pendingDrain -= amount;
        }

        private FluidEntry(TraderFluidStorage parent, FluidStack fluid) {
            this.parent = parent;
            this.filter = fluid.copy();
            if (!this.filter.isEmpty()) {
                this.filter.setAmount(1);
            }
            this.storedAmount = fluid.getAmount();
        }

        private FluidEntry(TraderFluidStorage parent, FluidStack fluid, int pendingDrain) {
            this.parent = parent;
            this.filter = fluid.copy();
            if (!this.filter.isEmpty()) {
                this.filter.setAmount(1);
            }
            this.storedAmount = fluid.getAmount();
            this.pendingDrain = pendingDrain;
        }

        private FluidEntry(TraderFluidStorage parent, FluidStack filter, int amount, int pendingDrain, boolean drainable, boolean fillable) {
            this.parent = parent;
            this.filter = filter;
            if (!this.filter.isEmpty()) {
                this.filter.setAmount(1);
            }
            this.storedAmount = amount;
            this.pendingDrain = pendingDrain;
            this.drainable = drainable;
            this.fillable = fillable;
        }

        public static FluidEntry load(TraderFluidStorage parent, CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
            FluidStack filter = FluidStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)compound.getCompound("Filter"));
            int amount = compound.getInt("Amount");
            int pendingDrain = compound.getInt("PendingDrain");
            boolean drainable = compound.getBoolean("Drainable");
            boolean fillable = compound.getBoolean("Fillable");
            return new FluidEntry(parent, filter, amount, pendingDrain, drainable, fillable);
        }

        private void save(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
            compound.put("Filter", this.filter.saveOptional(lookup));
            compound.putInt("Amount", this.storedAmount);
            compound.putInt("PendingDrain", this.pendingDrain);
            compound.putBoolean("Drainable", this.drainable);
            compound.putBoolean("Fillable", this.fillable);
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.getTankContents();
        }

        public int getTankCapacity(int tank) {
            return this.parent.getTankCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
            if (FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.filter) && !this.filter.isEmpty()) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, @Nonnull IFluidHandler.FluidAction action) {
            if (this.filter.isEmpty()) {
                return FluidStack.EMPTY;
            }
            int drainableAmount = Math.min(maxDrain, this.storedAmount - this.pendingDrain);
            FluidStack drainStack = this.filter.copy();
            drainStack.setAmount(drainableAmount);
            if (action.execute()) {
                this.removeAmount(drainableAmount);
            }
            return drainStack;
        }
    }
}

