/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid.tradedata.client;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid.FluidStorageClientTab;
import io.github.lightman314.lctech.client.gui.widget.button.trade.SpriteDisplayEntry;
import io.github.lightman314.lctech.common.menu.slots.FluidInputSlot;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class FluidTradeButtonRenderer
extends TradeRenderManager<FluidTradeData> {
    public FluidTradeButtonRenderer(FluidTradeData trade) {
        super((TradeData)trade);
    }

    public int tradeButtonWidth(TradeContext context) {
        return this.allowsDrainage(context) ? 87 : 76;
    }

    public Optional<ScreenPosition> arrowPosition(TradeContext tradeContext) {
        if (((FluidTradeData)this.trade).isSale()) {
            return ScreenPosition.ofOptional((int)36, (int)1);
        }
        return ScreenPosition.ofOptional((int)18, (int)1);
    }

    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, ((FluidTradeData)this.trade).isSale() ? 34 : 16, 16);
    }

    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        if (((FluidTradeData)this.trade).isSale()) {
            return this.lazyPriceDisplayList(context);
        }
        if (((FluidTradeData)this.trade).isPurchase()) {
            return this.getFluidEntry(context);
        }
        return null;
    }

    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(((FluidTradeData)this.trade).isSale() ? 58 : 40, 1, ((FluidTradeData)this.trade).isSale() ? (this.allowsDrainage(context) ? 32 : 16) : 34, 16);
    }

    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        if (((FluidTradeData)this.trade).isSale()) {
            return this.getFluidEntry(context);
        }
        if (((FluidTradeData)this.trade).isPurchase()) {
            return this.lazyPriceDisplayList(context);
        }
        return null;
    }

    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        TraderData traderData;
        if (context.hasTrader() && (traderData = context.getTrader()) instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (!trader.isCreative()) {
                if (((FluidTradeData)this.trade).getStock(context) <= 0) {
                    alerts.add(AlertData.warn((TextEntry)LCText.TOOLTIP_OUT_OF_STOCK));
                }
                if (!((FluidTradeData)this.trade).hasSpace(trader)) {
                    alerts.add(AlertData.warn((TextEntry)LCText.TOOLTIP_OUT_OF_SPACE));
                }
            }
            if (!((FluidTradeData)this.trade).canAfford(context)) {
                alerts.add(AlertData.warn((TextEntry)LCText.TOOLTIP_CANNOT_AFFORD));
            }
        }
        if (((FluidTradeData)this.trade).isSale() && !context.canFitFluid(((FluidTradeData)this.trade).productOfQuantity()) && !this.allowsDrainage(context)) {
            alerts.add(AlertData.warn((TextEntry)TechText.TOOLTIP_ALERT_NO_OUTPUT));
        }
    }

    private List<DisplayEntry> getFluidEntry(TradeContext context) {
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
        if (!((FluidTradeData)this.trade).getProduct().isEmpty()) {
            entries.add(DisplayEntry.of((ItemStack)((FluidTradeData)this.trade).getFilledBucket(), (int)((FluidTradeData)this.trade).getBucketQuantity(), this.getFluidTooltip(context)));
        } else if (context.isStorageMode) {
            entries.add(DisplayEntry.of(FluidInputSlot.BACKGROUND, (List)TechText.TOOLTIP_TRADER_FLUID_EDIT.getAsList(new Object[0])));
        }
        if (this.allowsDrainage(context)) {
            entries.add(SpriteDisplayEntry.of(FluidStorageClientTab.GUI_TEXTURE, 0, 0, 8, 8, TechText.TOOLTIP_TRADE_DRAINABLE.getAsList(new Object[0])));
        }
        return entries;
    }

    private List<Component> getFluidTooltip(TradeContext context) {
        if (((FluidTradeData)this.trade).getProduct().isEmpty()) {
            return null;
        }
        ArrayList tooltips = Lists.newArrayList();
        tooltips.add((((FluidTradeData)this.trade).isSale() ? TechText.TOOLTIP_TRADE_INFO_SELLING : TechText.TOOLTIP_TRADE_INFO_PURCHASING).get(new Object[]{FluidFormatUtil.getFluidName(((FluidTradeData)this.trade).getProduct(), ChatFormatting.GOLD)}).withStyle(ChatFormatting.GOLD));
        tooltips.add(TechText.TOOLTIP_TRADE_INFO_FLUID_QUANTITY.get(new Object[]{((FluidTradeData)this.trade).getBucketQuantity(), FluidFormatUtil.formatFluidAmount(((FluidTradeData)this.trade).getQuantity())}).withStyle(ChatFormatting.GOLD));
        if (context.hasTrader()) {
            tooltips.add(this.getStockTooltip(context.getTrader().isCreative(), ((FluidTradeData)this.trade).getStock(context)));
        }
        return tooltips;
    }

    private boolean allowsDrainage(TradeContext context) {
        if (context.isStorageMode || !((FluidTradeData)this.trade).isSale()) {
            return false;
        }
        TraderData traderData = context.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            return trader.drainCapable() && trader.hasOutputSide() && trader.getStorage().isDrainable(((FluidTradeData)this.trade).getProduct());
        }
        return false;
    }
}

