/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.datagen;

import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.datagen.client.TechFluidRenderDataProvider;
import io.github.lightman314.lctech.datagen.client.TechVariantProvider;
import io.github.lightman314.lctech.datagen.client.language.TechEnglishProvider;
import io.github.lightman314.lctech.datagen.common.crafting.TechRecipeProvider;
import io.github.lightman314.lctech.datagen.common.loot.TechBlockLootProvider;
import io.github.lightman314.lctech.datagen.common.tags.TechBlockTagProvider;
import io.github.lightman314.lctech.datagen.common.tags.TechItemTagProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="lctech")
public class LCTechDataEventListener {
    @SubscribeEvent
    public static void onDataGen(GatherDataEvent event) {
        TechConfig.COMMON.confirmSetup();
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupHolder = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new TechRecipeProvider(output, lookupHolder));
        TechBlockTagProvider blockTagProvider = new TechBlockTagProvider(output, lookupHolder, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new TechItemTagProvider(output, lookupHolder, blockTagProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(TechBlockLootProvider::new, LootContextParamSets.BLOCK)), lookupHolder));
        generator.addProvider(event.includeClient(), (DataProvider)new TechEnglishProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new TechFluidRenderDataProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new TechVariantProvider(output));
    }
}

