/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.datagen.common.crafting;

import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.TechTags;
import io.github.lightman314.lctech.common.core.ModBlocks;
import io.github.lightman314.lctech.common.crafting.condition.TechCraftingConditions;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.api.config.conditions.ConfigCraftingCondition;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.BooleanOption;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.crafting.condition.LCCraftingConditions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;

public class TechRecipeProvider
extends RecipeProvider {
    public TechRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        super(output, lookup);
    }

    protected void buildRecipes(@Nonnull RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)io.github.lightman314.lctech.common.core.ModItems.BATTERY.get())).unlockedBy("redstone", TechRecipeProvider.LazyTrigger((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).unlockedBy("batteries", TechRecipeProvider.LazyTrigger(TechTags.Items.BATTERIES)).unlockedBy("energy_trader", TechRecipeProvider.LazyTrigger(TechTags.Items.TRADER_ENERGY)).pattern(" i ").pattern("crc").pattern("crc").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).save(output.withConditions(new ICondition[]{TechCraftingConditions.BATTERIES}), TechRecipeProvider.ID("batteries/battery"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)io.github.lightman314.lctech.common.core.ModItems.BATTERY_LARGE.get())).unlockedBy("redstone", TechRecipeProvider.LazyTrigger((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).unlockedBy("batteries", TechRecipeProvider.LazyTrigger(TechTags.Items.BATTERIES)).unlockedBy("energy_trader", TechRecipeProvider.LazyTrigger(TechTags.Items.TRADER_ENERGY)).pattern(" i ").pattern("crc").pattern("crc").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('r'), Tags.Items.STORAGE_BLOCKS_REDSTONE).save(output.withConditions(new ICondition[]{TechCraftingConditions.BATTERIES}), TechRecipeProvider.ID("batteries/large_battery"));
        TechRecipeProvider.GenerateTankRecipe(output, (TagKey<Item>)Tags.Items.INGOTS_IRON, ModBlocks.IRON_TANK);
        TechRecipeProvider.GenerateTankRecipe(output, (TagKey<Item>)Tags.Items.INGOTS_GOLD, ModBlocks.GOLD_TANK);
        TechRecipeProvider.GenerateTankRecipe(output, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, ModBlocks.DIAMOND_TANK);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.DIAMOND_TANK.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)ModBlocks.NETHERITE_TANK.get().asItem()).unlocks("material", TechRecipeProvider.LazyTrigger((TagKey<Item>)Tags.Items.INGOTS_NETHERITE)).unlocks("glass", TechRecipeProvider.LazyTrigger((TagKey<Item>)Tags.Items.GLASS_BLOCKS_COLORLESS)).unlocks("bucket", TechRecipeProvider.LazyTrigger((ItemLike)Items.BUCKET)).unlocks("previous", TechRecipeProvider.LazyTrigger(ModBlocks.DIAMOND_TANK)).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TANK}), TechRecipeProvider.ItemID("fluid_tanks/", ModBlocks.NETHERITE_TANK));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FLUID_TAP.get())).unlockedBy("bucket", TechRecipeProvider.LazyTrigger((ItemLike)Items.BUCKET)).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("tank", TechRecipeProvider.LazyTrigger(TechTags.Items.FLUID_TANK)).pattern("c").pattern("t").pattern("n").define(Character.valueOf('c'), TechRecipeProvider.TradingCore()).define(Character.valueOf('t'), (ItemLike)ModBlocks.IRON_TANK.get()).define(Character.valueOf('n'), Tags.Items.NUGGETS_IRON).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER}), TechRecipeProvider.ID("traders/fluid/fluid_tap"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FLUID_TAP_BUNDLE.get())).unlockedBy("bucket", TechRecipeProvider.LazyTrigger((ItemLike)Items.BUCKET)).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("tank", TechRecipeProvider.LazyTrigger(TechTags.Items.FLUID_TANK)).unlockedBy("tap", TechRecipeProvider.LazyTrigger(ModBlocks.FLUID_TAP)).pattern(" t ").pattern("txt").pattern(" i ").define(Character.valueOf('x'), (ItemLike)ModBlocks.FLUID_TAP.get()).define(Character.valueOf('t'), (ItemLike)ModBlocks.IRON_TANK.get()).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER}), TechRecipeProvider.ID("traders/fluid/fluid_tap_bundle"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FLUID_NETWORK_TRADER_1.get())).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("terminal", TechRecipeProvider.TerminalKnowledge()).unlockedBy("tank", TechRecipeProvider.LazyTrigger(TechTags.Items.FLUID_TANK)).group("fluid_network_trader").pattern("iii").pattern("txt").pattern("iei").define(Character.valueOf('x'), TechRecipeProvider.TradingCore()).define(Character.valueOf('e'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('t'), (ItemLike)ModBlocks.IRON_TANK.get()).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER, LCCraftingConditions.NETWORK_TRADER}), TechRecipeProvider.ID("traders/network/fluid_network_trader_1"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FLUID_NETWORK_TRADER_2.get())).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("terminal", TechRecipeProvider.TerminalKnowledge()).unlockedBy("tank", TechRecipeProvider.LazyTrigger(TechTags.Items.FLUID_TANK)).group("fluid_network_trader").pattern("txt").define(Character.valueOf('t'), (ItemLike)ModBlocks.IRON_TANK.get()).define(Character.valueOf('x'), (ItemLike)ModBlocks.FLUID_NETWORK_TRADER_1.get()).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER, LCCraftingConditions.NETWORK_TRADER}), TechRecipeProvider.ID("traders/network/fluid_network_trader_2"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FLUID_NETWORK_TRADER_3.get())).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("terminal", TechRecipeProvider.TerminalKnowledge()).unlockedBy("tank", TechRecipeProvider.LazyTrigger(TechTags.Items.FLUID_TANK)).group("fluid_network_trader").pattern("txt").define(Character.valueOf('t'), (ItemLike)ModBlocks.IRON_TANK.get()).define(Character.valueOf('x'), (ItemLike)ModBlocks.FLUID_NETWORK_TRADER_2.get()).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER, LCCraftingConditions.NETWORK_TRADER}), TechRecipeProvider.ID("traders/network/fluid_network_trader_3"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FLUID_NETWORK_TRADER_4.get())).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("terminal", TechRecipeProvider.TerminalKnowledge()).unlockedBy("tank", TechRecipeProvider.LazyTrigger(TechTags.Items.FLUID_TANK)).group("fluid_network_trader").pattern("txt").define(Character.valueOf('t'), (ItemLike)ModBlocks.IRON_TANK.get()).define(Character.valueOf('x'), (ItemLike)ModBlocks.FLUID_NETWORK_TRADER_3.get()).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER, LCCraftingConditions.NETWORK_TRADER}), TechRecipeProvider.ID("traders/network/fluid_network_trader_4"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.BATTERY_SHOP.get())).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("battery", TechRecipeProvider.LazyTrigger(TechTags.Items.BATTERIES)).pattern("ibi").pattern("ici").define(Character.valueOf('c'), TechRecipeProvider.TradingCore()).define(Character.valueOf('b'), (ItemLike)io.github.lightman314.lctech.common.core.ModItems.BATTERY.get()).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).save(output.withConditions(new ICondition[]{TechCraftingConditions.ENERGY_TRADER}), TechRecipeProvider.ID("traders/energy/battery_shop"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ENERGY_NETWORK_TRADER.get())).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("terminal", TechRecipeProvider.TerminalKnowledge()).unlockedBy("battery", TechRecipeProvider.LazyTrigger(TechTags.Items.BATTERIES)).pattern("ibi").pattern("ixi").pattern("iei").define(Character.valueOf('x'), TechRecipeProvider.TradingCore()).define(Character.valueOf('e'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('b'), (ItemLike)io.github.lightman314.lctech.common.core.ModItems.BATTERY.get()).save(output.withConditions(new ICondition[]{TechCraftingConditions.ENERGY_TRADER, LCCraftingConditions.NETWORK_TRADER}), TechRecipeProvider.ID("traders/network/energy_network_trader"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FLUID_TRADER_INTERFACE.get())).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("terminal", TechRecipeProvider.TerminalKnowledge()).pattern("ici").pattern("iti").pattern("ici").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('t'), LCTags.Items.NETWORK_TERMINAL).define(Character.valueOf('c'), (ItemLike)ModBlocks.IRON_TANK.get()).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER, LCCraftingConditions.TRADER_INTERFACE}), TechRecipeProvider.ItemID(ModBlocks.FLUID_TRADER_INTERFACE));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ENERGY_TRADER_INTERFACE.get())).unlockedBy("trader", TechRecipeProvider.TraderKnowledge()).unlockedBy("terminal", TechRecipeProvider.TerminalKnowledge()).pattern("ici").pattern("iti").pattern("ici").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('t'), LCTags.Items.NETWORK_TERMINAL).define(Character.valueOf('c'), (ItemLike)io.github.lightman314.lctech.common.core.ModItems.BATTERY.get()).save(output.withConditions(new ICondition[]{TechCraftingConditions.ENERGY_TRADER, LCCraftingConditions.TRADER_INTERFACE}), TechRecipeProvider.ItemID(ModBlocks.ENERGY_TRADER_INTERFACE));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TechRecipeProvider.SmithingTemplate(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.BUCKET}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_1.get()).unlocks("trader", TechRecipeProvider.TraderKnowledge()).unlocks("bucket", TechRecipeProvider.LazyTrigger((ItemLike)Items.BUCKET)).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER}), TechRecipeProvider.ItemID("upgrades/", io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_1));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TechRecipeProvider.SmithingTemplate(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_1.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_2.get()).unlocks("trader", TechRecipeProvider.TraderKnowledge()).unlocks("bucket", TechRecipeProvider.LazyTrigger((ItemLike)Items.BUCKET)).unlocks("previous", TechRecipeProvider.LazyTrigger(io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_1)).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER}), TechRecipeProvider.ItemID("upgrades/", io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_2));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TechRecipeProvider.SmithingTemplate(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_2.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_3.get()).unlocks("trader", TechRecipeProvider.TraderKnowledge()).unlocks("bucket", TechRecipeProvider.LazyTrigger((ItemLike)Items.BUCKET)).unlocks("previous", TechRecipeProvider.LazyTrigger(io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_2)).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER}), TechRecipeProvider.ItemID("upgrades/", io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_3));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TechRecipeProvider.SmithingTemplate(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_3.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_4.get()).unlocks("trader", TechRecipeProvider.TraderKnowledge()).unlocks("bucket", TechRecipeProvider.LazyTrigger((ItemLike)Items.BUCKET)).unlocks("previous", TechRecipeProvider.LazyTrigger(io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_3)).save(output.withConditions(new ICondition[]{TechCraftingConditions.FLUID_TRADER}), TechRecipeProvider.ItemID("upgrades/", io.github.lightman314.lctech.common.core.ModItems.FLUID_CAPACITY_UPGRADE_4));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TechRecipeProvider.SmithingTemplate(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)io.github.lightman314.lctech.common.core.ModItems.BATTERY.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_1.get()).unlocks("trader", TechRecipeProvider.TraderKnowledge()).unlocks("battery", TechRecipeProvider.LazyTrigger(TechTags.Items.BATTERIES)).save(output.withConditions(new ICondition[]{TechCraftingConditions.ENERGY_TRADER}), TechRecipeProvider.ItemID("upgrades/", io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_1));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TechRecipeProvider.SmithingTemplate(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_1.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_2.get()).unlocks("trader", TechRecipeProvider.TraderKnowledge()).unlocks("battery", TechRecipeProvider.LazyTrigger(TechTags.Items.BATTERIES)).unlocks("previous", TechRecipeProvider.LazyTrigger(io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_1)).save(output.withConditions(new ICondition[]{TechCraftingConditions.ENERGY_TRADER}), TechRecipeProvider.ItemID("upgrades/", io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_2));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TechRecipeProvider.SmithingTemplate(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_2.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_3.get()).unlocks("trader", TechRecipeProvider.TraderKnowledge()).unlocks("battery", TechRecipeProvider.LazyTrigger(TechTags.Items.BATTERIES)).unlocks("previous", TechRecipeProvider.LazyTrigger(io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_2)).save(output.withConditions(new ICondition[]{TechCraftingConditions.ENERGY_TRADER}), TechRecipeProvider.ItemID("upgrades/", io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_3));
        SmithingTransformRecipeBuilder.smithing((Ingredient)TechRecipeProvider.SmithingTemplate(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_3.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_4.get()).unlocks("trader", TechRecipeProvider.TraderKnowledge()).unlocks("battery", TechRecipeProvider.LazyTrigger(TechTags.Items.BATTERIES)).unlocks("previous", TechRecipeProvider.LazyTrigger(io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_3)).save(output.withConditions(new ICondition[]{TechCraftingConditions.ENERGY_TRADER}), TechRecipeProvider.ItemID("upgrades/", io.github.lightman314.lctech.common.core.ModItems.ENERGY_CAPACITY_UPGRADE_4));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.VOID_TANK.get())).pattern("mgm").pattern("geg").pattern("mgm").unlockedBy("material", TechRecipeProvider.LazyTrigger((TagKey<Item>)Tags.Items.OBSIDIANS)).unlockedBy("glass", TechRecipeProvider.LazyTrigger((TagKey<Item>)Tags.Items.GLASS_BLOCKS_COLORLESS)).unlockedBy("bucket", TechRecipeProvider.LazyTrigger((ItemLike)Items.BUCKET)).unlockedBy("pearl", TechRecipeProvider.LazyTrigger((TagKey<Item>)Tags.Items.ENDER_PEARLS)).define(Character.valueOf('m'), Tags.Items.OBSIDIANS).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('e'), Tags.Items.ENDER_PEARLS).save(output.withConditions(new ICondition[]{TechCraftingConditions.VOID_TANK}), TechRecipeProvider.ID("fluid_tanks/void_tank"));
    }

    private static void GenerateTankRecipe(@Nonnull RecipeOutput output, @Nonnull TagKey<Item> ingredient, @Nonnull Supplier<? extends ItemLike> result) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result.get()).pattern("mgm").pattern("g g").pattern("mgm").unlockedBy("material", TechRecipeProvider.LazyTrigger(ingredient)).unlockedBy("glass", TechRecipeProvider.LazyTrigger((TagKey<Item>)Tags.Items.GLASS_BLOCKS_COLORLESS)).unlockedBy("bucket", TechRecipeProvider.LazyTrigger((ItemLike)Items.BUCKET)).define(Character.valueOf('m'), ingredient).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).save(output.withConditions(new ICondition[]{ConfigCraftingCondition.of((BooleanOption)TechConfig.COMMON.canCraftFluidTanks)}), TechRecipeProvider.ItemID("fluid_tanks/", result));
    }

    private static String ItemPath(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }

    private static String ItemPath(Supplier<? extends ItemLike> item) {
        return TechRecipeProvider.ItemPath(item.get());
    }

    private static ResourceLocation ItemID(String prefix, ItemLike item) {
        return TechRecipeProvider.ID(prefix + TechRecipeProvider.ItemPath(item));
    }

    private static ResourceLocation ItemID(Supplier<? extends ItemLike> item) {
        return TechRecipeProvider.ID(TechRecipeProvider.ItemPath(item));
    }

    private static ResourceLocation ItemID(String prefix, Supplier<? extends ItemLike> item) {
        return TechRecipeProvider.ID(prefix + TechRecipeProvider.ItemPath(item));
    }

    private static ResourceLocation ID(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)path);
    }

    private static ItemLike TradingCore() {
        return (ItemLike)ModItems.TRADING_CORE.get();
    }

    private static Ingredient SmithingTemplate() {
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()});
    }

    private static Criterion<?> TraderKnowledge() {
        return TechRecipeProvider.LazyTrigger((TagKey<Item>)LCTags.Items.TRADER);
    }

    private static Criterion<?> TerminalKnowledge() {
        return TechRecipeProvider.LazyTrigger((TagKey<Item>)LCTags.Items.NETWORK_TERMINAL);
    }

    private static Criterion<?> LazyTrigger(ItemLike item) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{item}).build()});
    }

    private static Criterion<?> LazyTrigger(List<? extends ItemLike> items) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(items.toArray(new ItemLike[0])).build()});
    }

    private static Criterion<?> LazyTrigger(Supplier<? extends ItemLike> item) {
        return TechRecipeProvider.LazyTrigger(item.get());
    }

    private static Criterion<?> LazyTrigger(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()});
    }
}

