/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.widget;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class FluidEditWidget
extends EasyWidgetWithChildren
implements IScrollable,
ITooltipSource {
    private static final List<Fluid> BLACKLISTED_FLUIDS = Lists.newArrayList((Object[])new Fluid[]{Fluids.f_76191_});
    private int scroll = 0;
    private final int columns;
    private final int rows;
    private final ScreenPosition searchOffset;
    private static List<Fluid> allFluids = null;
    List<Fluid> searchResultFluids;
    private String searchString;
    EditBox searchInput;
    private final Consumer<FluidStack> handler;
    private final Font font;

    public static void BlacklistFluid(Fluid fluid) {
        if (!BLACKLISTED_FLUIDS.contains(fluid)) {
            BLACKLISTED_FLUIDS.add(fluid);
        }
    }

    private FluidEditWidget(@Nonnull Builder builder) {
        super((EasyWidget.EasyBuilder)builder);
        this.handler = builder.handler;
        this.columns = builder.columns;
        this.rows = builder.rows;
        this.searchOffset = Objects.requireNonNullElse(builder.searchOffset, ScreenPosition.of((int)(this.f_93618_ - 90), (int)-13));
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
        this.modifySearch("");
    }

    public static void initFluidList() {
        if (allFluids != null) {
            return;
        }
        allFluids = new ArrayList<Fluid>();
        BuiltInRegistries.f_257020_.forEach(fluid -> {
            if (!BLACKLISTED_FLUIDS.contains(fluid) && fluid.m_7444_(fluid.m_76145_())) {
                allFluids.add((Fluid)fluid);
            }
        });
    }

    public int getMaxScroll() {
        return Math.max((this.searchResultFluids.size() - 1) / this.columns - this.rows + 1, 0);
    }

    public void refreshPage() {
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    public void refreshSearch() {
        this.modifySearch(this.searchString);
    }

    public void modifySearch(String newSearch) {
        this.searchString = newSearch.toLowerCase();
        if (!this.searchString.isEmpty()) {
            this.searchResultFluids = Lists.newArrayList();
            for (Fluid fluid : allFluids) {
                if (fluid.getFluidType().getDescription(new FluidStack(fluid, 1000)).getString().toLowerCase().contains(this.searchString)) {
                    this.searchResultFluids.add(fluid);
                    continue;
                }
                if (!BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString().contains(this.searchString)) continue;
                this.searchResultFluids.add(fluid);
            }
        } else {
            this.searchResultFluids = allFluids;
        }
    }

    public void addChildren(@Nonnull ScreenArea area) {
        this.searchInput = (EditBox)this.addChild(new EditBox(this.font, area.x + this.searchOffset.x + 2, area.y + this.searchOffset.y + 2, 79, 9, (Component)LCText.GUI_ITEM_EDIT_SEARCH.get(new Object[0])));
        this.searchInput.m_94182_(false);
        this.searchInput.m_94199_(32);
        this.searchInput.m_94202_(0xFFFFFF);
        this.searchInput.m_94151_(this::modifySearch);
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(area)).listener((IScrollable)this).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().onRight((EasyWidget)this).smallKnob().addon(EasyAddonHelper.visibleCheck(() -> ((FluidEditWidget)this).isVisible()))).build());
    }

    protected void renderTick() {
        this.searchInput.f_93624_ = this.f_93624_;
    }

    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        int index = this.scroll * this.columns;
        for (int y = 0; y < this.rows && index < this.searchResultFluids.size(); ++y) {
            int yPos = y * 18;
            for (int x = 0; x < this.columns && index < this.searchResultFluids.size(); ++index, ++x) {
                int xPos = x * 18;
                gui.resetColor();
                gui.blit(ItemEditWidget.GUI_TEXTURE, xPos, yPos, 0, 0, 18, 18);
                gui.renderItem(FluidItemUtil.getFluidDispayItem(this.searchResultFluids.get(index)), xPos + 1, yPos + 1);
            }
        }
        gui.resetColor();
        gui.blit(ItemEditWidget.GUI_TEXTURE, this.searchOffset, 18, 0, 90, 12);
    }

    public List<Component> getTooltipText(int mouseX, int mouseY) {
        if (!this.f_93624_) {
            return null;
        }
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultFluids.size()) {
            return Lists.newArrayList((Object[])new Component[]{FluidFormatUtil.getFluidName(new FluidStack(this.searchResultFluids.get(hoveredSlot), 1000))});
        }
        return null;
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        int foundColumn = -1;
        int foundRow = -1;
        for (int x = 0; x < this.columns && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(this.m_252754_() + x * 18)) || !(mouseX < (double)(this.m_252754_() + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < this.rows && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(this.m_252907_() + y * 18)) || !(mouseY < (double)(this.m_252907_() + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * this.columns + foundColumn;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultFluids.size()) {
            FluidStack fluid = new FluidStack(this.searchResultFluids.get(hoveredSlot), 1000);
            this.handler.accept(fluid);
            return true;
        }
        return false;
    }

    public int currentScroll() {
        return this.scroll;
    }

    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.refreshPage();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        int columns = 1;
        int rows = 1;
        @Nullable
        ScreenPosition searchOffset = null;
        private Consumer<FluidStack> handler = s -> {};

        private Builder() {
            super(18, 18);
        }

        protected Builder getSelf() {
            return this;
        }

        public Builder columns(int columns) {
            this.columns = columns;
            this.changeWidth(this.columns * 18);
            return this;
        }

        public Builder rows(int rows) {
            this.rows = rows;
            this.changeHeight(this.rows * 18);
            return this;
        }

        public Builder searchOffset(int searchOffX, int searchOffY) {
            return this.searchOffset(ScreenPosition.of((int)searchOffX, (int)searchOffY));
        }

        public Builder searchOffset(ScreenPosition searchOffset) {
            this.searchOffset = searchOffset;
            return this;
        }

        public Builder handler(Consumer<FluidStack> handler) {
            this.handler = handler;
            return this;
        }

        public FluidEditWidget build() {
            return new FluidEditWidget(this);
        }
    }
}

