/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lctech.client.resourcepacks.data.model_variants.TechProperties;
import io.github.lightman314.lctech.client.util.FluidRenderUtil;
import io.github.lightman314.lctech.common.blockentities.trader.FluidTraderBlockEntity;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidTraderBlockEntityRenderer
implements BlockEntityRenderer<FluidTraderBlockEntity> {
    public FluidTraderBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(FluidTraderBlockEntity blockEntity, float partialTicket, @Nonnull PoseStack pose, @Nonnull MultiBufferSource bufferSource, int light, int overlay) {
        FluidTraderData fluidTrader = (FluidTraderData)blockEntity.getTraderData();
        if (fluidTrader != null) {
            ModelVariant variant = ModelVariantDataManager.getVariant((ResourceLocation)blockEntity.getCurrentVariant());
            TechProperties.FluidRenderDataList renderDataOverrides = null;
            if (variant != null && variant.has(TechProperties.FLUID_RENDER_DATA)) {
                renderDataOverrides = (TechProperties.FluidRenderDataList)variant.get(TechProperties.FLUID_RENDER_DATA);
            }
            for (int tradeSlot = 0; tradeSlot < fluidTrader.getTradeCount() && tradeSlot < blockEntity.getTradeRenderLimit(); ++tradeSlot) {
                FluidRenderData newData;
                FluidTradeData trade = fluidTrader.getTrade(tradeSlot);
                FluidStack fluid = trade.getProduct();
                if (fluid.isEmpty()) continue;
                int tankQuantity = fluidTrader.getStorage().getActualFluidCount(fluid);
                FluidRenderData renderData = blockEntity.getRenderPosition(tradeSlot);
                if (renderDataOverrides != null && (newData = renderDataOverrides.get(blockEntity.getRenderPositionIndex(tradeSlot))) != null) {
                    renderData = newData;
                }
                if (renderData == null || tankQuantity <= 0) continue;
                renderData.setFillPercent((float)Math.min(1.0, (double)tankQuantity / (double)fluidTrader.getTankCapacity()));
                FluidRenderUtil.drawFluidInWorld(fluid, blockEntity.m_58904_(), blockEntity.m_58899_(), pose, bufferSource, renderData, light);
            }
        }
    }
}

