/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.client.util.FluidSides;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;

public class FluidRenderData {
    public final float x;
    public final float y;
    public final float z;
    public final float width;
    public final float height;
    public final float depth;
    public final FluidSides sides;
    private float fillPercent = 1.0f;

    public final float getHeight() {
        return this.height * this.fillPercent;
    }

    public float getFillPercent() {
        return this.fillPercent;
    }

    public void setFillPercent(float fillPercent) {
        this.fillPercent = MathUtil.clamp((float)fillPercent, (float)0.0f, (float)1.0f);
    }

    private FluidRenderData(float x, float y, float z, float width, float height, float depth, FluidSides sides) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.sides = sides;
    }

    public FluidRenderData withSides(FluidSides sidesOverride) {
        return new FluidRenderData(this.x, this.y, this.z, this.width, this.height, this.depth, sidesOverride);
    }

    public FluidRenderData withSides(boolean shouldOverride, FluidSides sidesOverride) {
        return shouldOverride ? this.withSides(sidesOverride) : this;
    }

    public FluidRenderData withSides(boolean overrideFlag, FluidSides sidesOverride1, FluidSides sidesOverride2) {
        return overrideFlag ? this.withSides(sidesOverride1) : this.withSides(sidesOverride2);
    }

    public static FluidRenderData CreateFluidRender(float x, float y, float z, float width, float height, float depth) {
        return FluidRenderData.CreateFluidRender(x, y, z, width, height, depth, FluidSides.ALL);
    }

    public static FluidRenderData CreateFluidRender(float x, float y, float z, float width, float height, float depth, FluidSides sides) {
        return new FluidRenderData(x / 16.0f, y / 16.0f, z / 16.0f, width / 16.0f, height / 16.0f, depth / 16.0f, sides);
    }

    public static FluidRenderData parse(@Nonnull JsonObject json) throws JsonSyntaxException, IllegalArgumentException {
        float x = GsonHelper.m_13915_((JsonObject)json, (String)"x");
        float y = GsonHelper.m_13915_((JsonObject)json, (String)"y");
        float z = GsonHelper.m_13915_((JsonObject)json, (String)"z");
        float width = GsonHelper.m_13915_((JsonObject)json, (String)"width");
        float height = GsonHelper.m_13915_((JsonObject)json, (String)"height");
        float depth = GsonHelper.m_13915_((JsonObject)json, (String)"depth");
        FluidSides sides = FluidSides.ALL;
        if (json.has("sides")) {
            JsonArray sidesList = GsonHelper.m_13933_((JsonObject)json, (String)"sides");
            ArrayList<Direction> result = new ArrayList<Direction>();
            for (int i = 0; i < sidesList.size(); ++i) {
                String entry = GsonHelper.m_13805_((JsonElement)sidesList.get(i), (String)("sides[" + i + "]"));
                Direction entryValue = (Direction)EnumUtil.enumFromString((String)entry, (Enum[])Direction.values(), null);
                if (entryValue == null) {
                    LCTech.LOGGER.warn("Could not parse {} as a Direction", (Object)entry);
                    continue;
                }
                if (result.contains(entryValue)) {
                    LCTech.LOGGER.warn("Duplicate side {}", (Object)entry);
                    continue;
                }
                result.add(entryValue);
            }
            sides = FluidSides.Create(result::contains);
        }
        return new FluidRenderData(x, y, z, width, height, depth, sides);
    }

    public JsonObject write() {
        JsonObject json = new JsonObject();
        json.addProperty("x", (Number)Float.valueOf(this.x));
        json.addProperty("y", (Number)Float.valueOf(this.y));
        json.addProperty("z", (Number)Float.valueOf(this.z));
        json.addProperty("width", (Number)Float.valueOf(this.width));
        json.addProperty("height", (Number)Float.valueOf(this.height));
        json.addProperty("depth", (Number)Float.valueOf(this.depth));
        if (!this.sides.equals(FluidSides.ALL)) {
            JsonArray sideList = new JsonArray();
            for (Direction side : Direction.values()) {
                if (!this.sides.test(side)) continue;
                sideList.add(side.toString());
            }
            json.add("sides", (JsonElement)sideList);
        }
        return json;
    }
}

