/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.resourcepacks.data.model_variants;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.VariantProperty;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TechProperties {
    public static final VariantProperty<FluidRenderDataList> FLUID_RENDER_DATA = new FluidRenderDataProperty();

    private static class FluidRenderDataProperty
    extends VariantProperty<FluidRenderDataList> {
        private FluidRenderDataProperty() {
        }

        public FluidRenderDataList parse(JsonElement element) throws JsonSyntaxException, ResourceLocationException {
            ArrayList<FluidRenderDataEntry> list = new ArrayList<FluidRenderDataEntry>();
            String elementName = this.getID().toString();
            if (element.isJsonArray()) {
                JsonArray arrray = GsonHelper.m_13924_((JsonElement)element, (String)elementName);
                for (int i = 0; i < arrray.size(); ++i) {
                    list.add(this.parseEntry(arrray.get(i), elementName + "[" + i + "]"));
                }
            } else {
                list.add(this.parseEntry(element, elementName));
            }
            return new FluidRenderDataList(list);
        }

        private FluidRenderDataEntry parseEntry(JsonElement element, String name) {
            if (element.isJsonPrimitive()) {
                ResourceLocation dataID = VersionUtil.parseResource((String)GsonHelper.m_13805_((JsonElement)element, (String)name));
                return new IDEntry(dataID);
            }
            return new InstanceEntry(FluidRenderData.parse(GsonHelper.m_13918_((JsonElement)element, (String)name)));
        }

        public JsonElement write(Object value) {
            if (value instanceof FluidRenderDataList) {
                FluidRenderDataList data = (FluidRenderDataList)value;
                return data.write();
            }
            throw new IllegalArgumentException("Value must be a FluidRenderDataEntry element!");
        }
    }

    private record InstanceEntry(FluidRenderData data) implements FluidRenderDataEntry
    {
        @Override
        public FluidRenderData get() {
            return this.data;
        }

        @Override
        public JsonElement write() {
            return this.data.write();
        }
    }

    private record IDEntry(ResourceLocation renderDataID) implements FluidRenderDataEntry
    {
        @Override
        public FluidRenderData get() {
            return FluidRenderDataManager.getDataOrEmpty(this.renderDataID);
        }

        @Override
        public JsonElement write() {
            return new JsonPrimitive(this.renderDataID.toString());
        }
    }

    public static interface FluidRenderDataEntry {
        public FluidRenderData get();

        public JsonElement write();

        public static FluidRenderDataEntry create(ResourceLocation renderDataID) {
            return new IDEntry(renderDataID);
        }

        public static FluidRenderDataEntry create(FluidRenderData data) {
            return new InstanceEntry(data);
        }
    }

    public static class FluidRenderDataList {
        private final List<FluidRenderDataEntry> values;

        @Nullable
        public FluidRenderData get(int index) {
            if (index < 0 || index >= this.values.size()) {
                return null;
            }
            return this.values.get(index).get();
        }

        public FluidRenderDataList(FluidRenderDataEntry value) {
            this((List<FluidRenderDataEntry>)ImmutableList.of((Object)value));
        }

        public FluidRenderDataList(List<FluidRenderDataEntry> values) {
            this.values = values;
        }

        JsonArray write() {
            JsonArray list = new JsonArray();
            for (FluidRenderDataEntry entry : this.values) {
                list.add(entry.write());
            }
            return list;
        }
    }
}

