/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.FluidTankBlockEntity;
import io.github.lightman314.lctech.common.blocks.FluidTankBlock;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidTankItem
extends BlockItem {
    private static final List<FluidTankItem> TANK_ITEMS = Lists.newArrayList();

    @OnlyIn(value=Dist.CLIENT)
    public static List<ModelResourceLocation> getTankModelList() {
        ArrayList list = Lists.newArrayList();
        TANK_ITEMS.forEach(tankItem -> list.add(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)tankItem), "inventory")));
        return list;
    }

    public FluidTankItem(Block block, Item.Properties properties) {
        super(block, properties);
        TANK_ITEMS.add(this);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        FluidStack fluid = FluidTankItem.GetFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((Component)FluidFormatUtil.getFluidName(fluid));
            int capacity = FluidTankItem.GetCapacity(stack);
            tooltip.add((Component)Component.m_237113_((String)(FluidFormatUtil.formatFluidAmount(fluid.getAmount()) + "mB / " + FluidFormatUtil.formatFluidAmount(capacity) + "mB")).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)TechText.TOOLTIP_TANK_CAPACITY.get(new Object[]{FluidFormatUtil.formatFluidAmount(FluidTankItem.GetCapacity(stack))}));
        }
    }

    public static FluidStack GetFluid(ItemStack stack) {
        if (stack.m_41720_() instanceof FluidTankItem) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                return FluidStack.EMPTY;
            }
            if (tag.m_128425_("Tank", 10)) {
                return FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Tank"));
            }
        }
        return FluidStack.EMPTY;
    }

    private FluidTankBlock getTankBlock() {
        Block block = this.m_40614_();
        if (block instanceof FluidTankBlock) {
            return (FluidTankBlock)block;
        }
        return null;
    }

    public static int GetCapacity(ItemStack stack) {
        FluidTankBlock block;
        if (stack.m_41720_() instanceof FluidTankItem && (block = ((FluidTankItem)stack.m_41720_()).getTankBlock()) != null) {
            return block.getTankCapacity();
        }
        return 10000;
    }

    public static ItemStack GetItemFromTank(@Nonnull FluidTankBlockEntity blockEntity) {
        ItemStack returnStack = new ItemStack((ItemLike)blockEntity.m_58900_().m_60734_().m_5456_());
        FluidStack tank = blockEntity.getTankContents();
        FluidTankItem.WriteTankData(returnStack, tank);
        return returnStack;
    }

    public static void WriteTankData(ItemStack stack, FluidStack tank) {
        if (tank.isEmpty()) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                return;
            }
            tag.m_128473_("Tank");
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            }
        } else {
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_("Tank", (Tag)tank.writeToNBT(new CompoundTag()));
            stack.m_41751_(tag);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag compound) {
        return new FluidTankCapability(stack);
    }

    public static class FluidTankCapability
    implements IFluidHandlerItem,
    ICapabilityProvider {
        final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
        final ItemStack stack;

        private FluidStack tank() {
            return FluidTankItem.GetFluid(this.stack);
        }

        private void setTank(FluidStack tank) {
            FluidTankItem.WriteTankData(this.stack, tank);
        }

        private int capacity() {
            return FluidTankItem.GetCapacity(this.stack);
        }

        private int getTankSpace() {
            return this.capacity() - this.tank().getAmount();
        }

        public FluidTankCapability(ItemStack stack) {
            this.stack = stack;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? this.tank().copy() : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? this.capacity() : 10000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0 && (this.tank().isEmpty() || this.tank().isFluidEqual(stack));
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.isFluidValid(0, resource)) {
                int fillAmount = MathUtil.clamp((int)resource.getAmount(), (int)0, (int)this.getTankSpace());
                if (action.execute()) {
                    if (this.tank().isEmpty()) {
                        this.setTank(resource.copy());
                    } else {
                        FluidStack tank = this.tank();
                        tank.grow(fillAmount);
                        this.setTank(tank);
                    }
                }
                return fillAmount;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.tank().isEmpty() || !this.tank().isFluidEqual(resource)) {
                return FluidStack.EMPTY;
            }
            int drainAmount = MathUtil.clamp((int)resource.getAmount(), (int)0, (int)this.tank().getAmount());
            FluidStack resultStack = this.tank().copy();
            resultStack.setAmount(drainAmount);
            if (action.execute()) {
                FluidStack tank = this.tank();
                tank.shrink(drainAmount);
                if (tank.isEmpty()) {
                    tank = FluidStack.EMPTY;
                }
                this.setTank(tank);
            }
            return resultStack;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.tank().isEmpty()) {
                return FluidStack.EMPTY;
            }
            int drainAmount = MathUtil.clamp((int)maxDrain, (int)0, (int)this.tank().getAmount());
            FluidStack resultStack = this.tank().copy();
            resultStack.setAmount(drainAmount);
            if (action.execute()) {
                FluidStack tank = this.tank();
                tank.shrink(drainAmount);
                if (tank.isEmpty()) {
                    tank = FluidStack.EMPTY;
                }
                this.setTank(tank);
            }
            return resultStack;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction side) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(capability, this.holder);
        }
    }
}

