/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech;

import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.core.ModRegistries;
import io.github.lightman314.lctech.common.notifications.types.EnergyTradeNotification;
import io.github.lightman314.lctech.common.notifications.types.FluidTradeNotification;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.terminal.filters.FluidTraderSearchFilter;
import io.github.lightman314.lctech.common.util.icons.FluidIcon;
import io.github.lightman314.lctech.integration.lcdiscord.TechDiscord;
import io.github.lightman314.lctech.network.LCTechPacketHandler;
import io.github.lightman314.lctech.proxy.ClientProxy;
import io.github.lightman314.lctech.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.ITraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.upgrades.Upgrades;
import io.github.lightman314.lightmanscurrency.integration.IntegrationUtil;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lctech")
public class LCTech {
    public static final String MODID = "lctech";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static final Logger LOGGER = LogManager.getLogger();

    public LCTech() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        TechConfig.init();
        ModRegistries.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        PROXY.init();
        IntegrationUtil.SafeRunIfLoaded((String)"lightmansdiscord", TechDiscord::setup, (String)"Error setting up Tech Discord Integration");
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        LCTech.safeEnqueueWork((ParallelDispatchEvent)event, "Error during common setup!", this::commonSetupWork);
    }

    private void commonSetupWork() {
        LCTechPacketHandler.init();
        TraderAPI.getApi().RegisterSearchFilter((ITraderSearchFilter)new FluidTraderSearchFilter());
        TraderAPI.getApi().RegisterTrader(FluidTraderData.TYPE);
        TraderAPI.getApi().RegisterTrader(EnergyTraderData.TYPE);
        NotificationAPI.getApi().RegisterNotification(FluidTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(EnergyTradeNotification.TYPE);
        Upgrades.TRADE_OFFERS.addTarget((Component)TechText.TOOLTIP_UPGRADE_TARGET_TRADER_FLUID.get(new Object[0]));
        Upgrades.VOID.addTarget((Component)TechText.TOOLTIP_UPGRADE_TARGET_TRADER_FLUID.get(new Object[0]));
        Upgrades.VOID.addTarget((Component)TechText.TOOLTIP_UPGRADE_TARGET_TRADER_ENERGY.get(new Object[0]));
        FluidIcon.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LCTech.safeEnqueueWork((ParallelDispatchEvent)event, "Error during client setup!", PROXY::setupClient);
    }

    public static void safeEnqueueWork(ParallelDispatchEvent event, String errorMessage, Runnable work) {
        event.enqueueWork(() -> {
            try {
                work.run();
            }
            catch (Throwable t) {
                LOGGER.error(errorMessage, t);
            }
        });
    }
}

