/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.energy;

import io.github.lightman314.lctech.client.gui.TechSprites;
import io.github.lightman314.lctech.common.core.ModItems;
import io.github.lightman314.lctech.common.items.IBatteryItem;
import io.github.lightman314.lctech.common.menu.traderstorage.energy.EnergyStorageTab;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergyStorageClientTab
extends TraderStorageClientTab<EnergyStorageTab> {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int FRAME_HEIGHT = 90;
    private static final int ENERGY_BAR_HEIGHT = 88;

    public EnergyStorageClientTab(Object screen, EnergyStorageTab commonTab) {
        super(screen, (TraderStorageTab)commonTab);
    }

    public IconData getIcon() {
        return ItemIcon.ofItem((ItemStack)IBatteryItem.HideEnergyBar(ModItems.BATTERY_LARGE));
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_STORAGE.get(new Object[0]);
    }

    public boolean blockInventoryClosing() {
        return false;
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
    }

    public void renderBG(EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.TOOLTIP_TRADER_STORAGE.get(new Object[0]), 8, 6, 0x404040);
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            gui.resetColor();
            for (Slot slot : ((EnergyStorageTab)this.commonTab).getSlots()) {
                gui.renderSlot((IEasyScreen)this.screen, slot);
            }
            SpriteUtil.SMALL_ARROW_UP.render(gui, 26, 110);
            SpriteUtil.SMALL_ARROW_DOWN.render(gui, 62, 110);
            TechSprites.BATTERY_BACKGROUND.render(gui, 13, 17, 90);
            double fillPercent = (double)trader.getTotalEnergy() / (double)trader.getMaxEnergy();
            int fillHeight = MathUtil.clamp((int)((int)(88.0 * fillPercent)), (int)0, (int)88);
            int yOffset = 88 - fillHeight + 1;
            TechSprites.BATTERY_FILLER.render(gui, 14, 17 + yOffset, fillHeight);
        }
    }

    public void renderAfterWidgets(EasyGuiGraphics gui) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            if (this.isMouseOverEnergy(gui.mousePos)) {
                gui.renderComponentTooltip(EnergyTraderData.getEnergyHoverTooltip(trader));
            }
        }
    }

    private boolean isMouseOverEnergy(ScreenPosition mousePos) {
        int leftEdge = ((ITraderStorageScreen)this.screen).getGuiLeft() + 13;
        int topEdge = ((ITraderStorageScreen)this.screen).getGuiTop() + 17;
        return mousePos.x >= leftEdge && mousePos.x < leftEdge + 18 && mousePos.y >= topEdge && mousePos.y < topEdge + 90;
    }
}

