/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blocks.traderblocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderDataManager;
import io.github.lightman314.lctech.common.blockentities.trader.FluidTraderBlockEntity;
import io.github.lightman314.lctech.common.blocks.IFluidTraderBlock;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FluidTapBundleBlock
extends TraderBlockRotatable
implements IFluidTraderBlock {
    public static final ResourceLocation DATA_NW = VersionUtil.modResource((String)"lctech", (String)"fluid_tap_bundle/nw");
    public static final ResourceLocation DATA_NE = VersionUtil.modResource((String)"lctech", (String)"fluid_tap_bundle/ne");
    public static final ResourceLocation DATA_SW = VersionUtil.modResource((String)"lctech", (String)"fluid_tap_bundle/sw");
    public static final ResourceLocation DATA_SE = VersionUtil.modResource((String)"lctech", (String)"fluid_tap_bundle/se");
    public static final List<ResourceLocation> FLUID_RENDER = Lists.newArrayList((Object[])new ResourceLocation[]{DATA_NW, DATA_NE, DATA_SW, DATA_SE});
    private static final List<Direction> IGNORELIST = Lists.newArrayList((Object[])new Direction[]{Direction.UP, Direction.DOWN});
    private static final Map<Direction, List<ResourceLocation>> RENDERMAP = Maps.newHashMap();

    public FluidTapBundleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public FluidTapBundleBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties, shape);
    }

    protected boolean isBlockOpaque() {
        return false;
    }

    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new FluidTraderBlockEntity(pos, state, 4);
    }

    protected BlockEntityType<?> traderType() {
        return ModBlockEntities.FLUID_TRADER.get();
    }

    @Override
    public int getTradeRenderLimit() {
        return 4;
    }

    @Override
    public FluidRenderData getRenderPosition(BlockState state, int index) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!RENDERMAP.containsKey(facing)) {
            FluidTapBundleBlock.initRenderMap(facing);
        }
        if (RENDERMAP.containsKey(facing)) {
            List<ResourceLocation> renderList = RENDERMAP.get(facing);
            if (index < 0 || index >= renderList.size()) {
                return null;
            }
            return FluidRenderDataManager.getDataOrEmpty(renderList.get(index));
        }
        return null;
    }

    private static void initRenderMap(Direction direction) {
        if (IGNORELIST.contains(direction)) {
            return;
        }
        List<ResourceLocation> list = FluidTapBundleBlock.createList(FluidTapBundleBlock.getRenderOrder(direction));
        if (!list.isEmpty()) {
            RENDERMAP.put(direction, list);
        } else {
            IGNORELIST.add(direction);
        }
    }

    public static List<ResourceLocation> getRenderID(Direction facing) {
        if (!RENDERMAP.containsKey(facing)) {
            FluidTapBundleBlock.initRenderMap(facing);
        }
        return RENDERMAP.getOrDefault(facing, new ArrayList());
    }

    private static List<Integer> getRenderOrder(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3);
            case Direction.EAST -> ImmutableList.of((Object)1, (Object)3, (Object)0, (Object)2);
            case Direction.SOUTH -> ImmutableList.of((Object)3, (Object)2, (Object)1, (Object)0);
            case Direction.WEST -> ImmutableList.of((Object)2, (Object)0, (Object)3, (Object)1);
            default -> ImmutableList.of();
        };
    }

    private static List<ResourceLocation> createList(List<Integer> indexes) {
        ArrayList list = Lists.newArrayList();
        for (int index : indexes) {
            if (index < 0 || index >= FLUID_RENDER.size()) continue;
            list.add(FLUID_RENDER.get(index));
        }
        return list;
    }

    protected Supplier<List<Component>> getItemTooltips() {
        return TechText.TOOLTIP_FLUID_TRADER.asTooltip(new Object[]{4});
    }
}

