/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VoidTankItem
extends BlockItem {
    public VoidTankItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new VoidFluidHandler(stack);
    }

    private static class VoidFluidHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
        final ItemStack item;

        VoidFluidHandler(ItemStack item) {
            this.item = item;
        }

        public ItemStack getContainer() {
            return this.item;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int i) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int i) {
            return 0x3FFFFFFF;
        }

        public boolean isFluidValid(int i, FluidStack fluidStack) {
            return true;
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return fluidStack.getAmount();
        }

        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(capability, this.holder);
        }
    }
}

