/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderinterface.fluid;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderinterface.fluid.FluidStorageClientTab;
import io.github.lightman314.lctech.common.blockentities.FluidTraderInterfaceBlockEntity;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.slot.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidStorageTab
extends TraderInterfaceTab {
    List<EasySlot> slots = new ArrayList<EasySlot>();

    public FluidStorageTab(TraderInterfaceMenu menu) {
        super(menu);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new FluidStorageClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    public void onTabOpen() {
        EasySlot.SetActive(this.slots);
    }

    public void onTabClose() {
        EasySlot.SetInactive(this.slots);
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        for (int i = 0; i < ((TraderInterfaceMenu)this.menu).getBE().getUpgrades().m_6643_(); ++i) {
            UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(((TraderInterfaceMenu)this.menu).getBE().getUpgrades(), i, 176, 18 + 18 * i, (IUpgradeable)((TraderInterfaceMenu)this.menu).getBE());
            upgradeSlot.active = false;
            upgradeSlot.setListener(this::onUpgradeModified);
            addSlot.apply((Slot)upgradeSlot);
            this.slots.add((EasySlot)upgradeSlot);
        }
    }

    private void onUpgradeModified() {
        ((TraderInterfaceMenu)this.menu).getBE().setUpgradeSlotsDirty();
    }

    public void interactWithTank(int tank, boolean shiftHeld) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof FluidTraderInterfaceBlockEntity) {
            ItemStack heldStack;
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            if (((TraderInterfaceMenu)this.menu).isClient()) {
                ((TraderInterfaceMenu)this.menu).SendMessage(LazyPacketData.builder().setInt("InteractWithTank", tank).setBoolean("ShiftHeld", shiftHeld));
            }
            if ((heldStack = ((TraderInterfaceMenu)this.menu).m_142621_()).m_41619_()) {
                return;
            }
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)heldStack, (IFluidHandler)be.getFluidBuffer(), (int)Integer.MAX_VALUE, (Player)((TraderInterfaceMenu)this.menu).player, (boolean)true);
            if (result.isSuccess()) {
                if (((TraderInterfaceMenu)this.menu).player.m_7500_() && result.getResult().m_41720_() == Items.f_42446_) {
                    if (shiftHeld) {
                        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)heldStack).orElse(FluidStack.EMPTY);
                        TraderFluidStorage.FluidEntry entry = be.getFluidBuffer().getTank(fluid);
                        if (entry != null) {
                            entry.setAmount(be.getTankCapacity());
                        }
                    }
                    be.setFluidBufferDirty();
                    return;
                }
                be.setFluidBufferDirty();
                if (heldStack.m_41613_() > 1) {
                    heldStack.m_41774_(1);
                    ((TraderInterfaceMenu)this.menu).m_142503_(heldStack);
                    ItemHandlerHelper.giveItemToPlayer((Player)((TraderInterfaceMenu)this.menu).player, (ItemStack)result.getResult());
                } else {
                    ((TraderInterfaceMenu)this.menu).m_142503_(result.getResult());
                }
            } else {
                if (tank < 0 || tank >= be.getFluidBuffer().getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry tankEntry = be.getFluidBuffer().getContents().get(tank);
                result = FluidUtil.tryFillContainer((ItemStack)heldStack, (IFluidHandler)tankEntry, (int)Integer.MAX_VALUE, (Player)((TraderInterfaceMenu)this.menu).player, (boolean)true);
                if (result.isSuccess()) {
                    if (((TraderInterfaceMenu)this.menu).player.m_7500_() && heldStack.m_41720_() == Items.f_42446_) {
                        if (shiftHeld) {
                            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)result.getResult()).orElse(FluidStack.EMPTY);
                            TraderFluidStorage.FluidEntry entry = be.getFluidBuffer().getTank(fluid);
                            if (entry != null) {
                                entry.setAmount(0);
                            }
                        }
                        be.getFluidBuffer().clearInvalidTanks();
                        be.setFluidBufferDirty();
                        return;
                    }
                    be.getFluidBuffer().clearInvalidTanks();
                    be.setFluidBufferDirty();
                    if (heldStack.m_41613_() > 1) {
                        heldStack.m_41774_(1);
                        ((TraderInterfaceMenu)this.menu).m_142503_(heldStack);
                        ItemHandlerHelper.giveItemToPlayer((Player)((TraderInterfaceMenu)this.menu).player, (ItemStack)result.getResult());
                    } else {
                        ((TraderInterfaceMenu)this.menu).m_142503_(result.getResult());
                    }
                }
            }
        }
    }

    public void toggleSide(Direction side, DirectionalSettingsState state) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (((TraderInterfaceMenu)this.menu).getBE().canAccess(((TraderInterfaceMenu)this.menu).player) && (traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE()) instanceof FluidTraderInterfaceBlockEntity) {
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            be.getFluidHandler().toggleSide(side, state);
            be.setHandlerDirty((SidedHandler)be.getFluidHandler());
        }
    }

    public void handleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("InteractWithTank", (byte)2)) {
            this.interactWithTank(message.getInt("InteractWithTank"), message.getBoolean("ShiftHeld"));
        }
    }
}

