/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.util.icons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lctech.client.util.FluidRenderUtil;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(VersionUtil.modResource((String)"lctech", (String)"fluid"), FluidIcon::loadFluid, FluidIcon::parseFluid);
    private final FluidStack fluid;

    public static void register() {
        IconData.registerIconType((IconData.Type)TYPE);
    }

    private FluidIcon(FluidStack fluid) {
        super(TYPE);
        this.fluid = fluid;
    }

    public static FluidIcon ofFluid(FluidStack fluid) {
        return new FluidIcon(fluid);
    }

    public void render(EasyGuiGraphics gui, int x, int y) {
        FluidRenderUtil.drawFluidTankInGUI(this.fluid, gui, x, y, 16, 16, 1.0);
    }

    protected void saveAdditional(CompoundTag tag) {
        tag.m_128365_("Fluid", (Tag)this.fluid.writeToNBT(new CompoundTag()));
    }

    protected void writeAdditional(JsonObject json) {
        json.add("Fluid", (JsonElement)FluidItemUtil.convertFluidStack(this.fluid));
    }

    public boolean matches(FluidIcon other) {
        return this.fluid.getFluid() == other.fluid.getFluid() && FluidStack.areFluidStackTagsEqual((FluidStack)this.fluid, (FluidStack)other.fluid);
    }

    private static IconData loadFluid(CompoundTag tag) {
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid"));
        return new FluidIcon(fluid);
    }

    private static IconData parseFluid(JsonObject json) {
        FluidStack fluid = FluidItemUtil.parseFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)"Fluid"));
        return new FluidIcon(fluid);
    }
}

