/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lctech.client.util.FluidSides;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidRenderDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FluidRenderDataManager INSTANCE = new FluidRenderDataManager();
    private final Map<ResourceLocation, FluidRenderData> fluidRenderData = new HashMap<ResourceLocation, FluidRenderData>();

    public static FluidRenderData getDataOrEmpty(ResourceLocation id) {
        return FluidRenderDataManager.INSTANCE.fluidRenderData.getOrDefault(id, FluidRenderData.CreateFluidRender(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, FluidSides.Create(new Direction[0])));
    }

    private FluidRenderDataManager() {
        super(GSON, "lctech/fluid_render_data");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller filler) {
        this.fluidRenderData.clear();
        map.forEach((id, json) -> {
            try {
                FluidRenderData data = FluidRenderData.parse(GsonHelper.m_13918_((JsonElement)json, (String)"top element"));
                this.fluidRenderData.put((ResourceLocation)id, data);
            }
            catch (JsonSyntaxException | IllegalArgumentException exception) {
                LCTech.LOGGER.error("Parsing error loading fluid render data {}", id, (Object)exception);
            }
        });
    }
}

