/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities;

import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class VoidTankBlockEntity
extends EasyBlockEntity {
    public static final IFluidHandler VOID_HANDLER = new VoidFluidHandler();
    private static final LazyOptional<IFluidHandler> OPTIONAL = LazyOptional.of(() -> VOID_HANDLER);

    public VoidTankBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        super(ModBlockEntities.VOID_TANK.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, OPTIONAL);
    }

    private static class VoidFluidHandler
    implements IFluidHandler {
        private VoidFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int i) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int i) {
            return 0x3FFFFFFF;
        }

        public boolean isFluidValid(int i, @Nonnull FluidStack fluidStack) {
            return true;
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return fluidStack.getAmount();
        }

        @Nonnull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }
    }
}

