/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderstorage.fluid;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid.FluidTradeEditClientTab;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class FluidTradeEditTab
extends TraderStorageTab {
    int tradeIndex = -1;

    public FluidTradeEditTab(ITraderStorageMenu menu) {
        super(menu);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new FluidTradeEditClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).getTrader().hasPermission(player, "editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public FluidTradeData getTrade() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (this.tradeIndex >= trader.getTradeCount() || this.tradeIndex < 0) {
                ((ITraderStorageMenu)this.menu).ChangeTab(0);
                return null;
            }
            return trader.getTrade(this.tradeIndex);
        }
        return null;
    }

    public void onTabOpen() {
    }

    public void onTabClose() {
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setType(TradeDirection type) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTradeDirection(type);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(LazyPacketData.simpleInt((String)"NewType", (int)type.index));
            }
        }
    }

    public void setQuantity(int amount) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setBucketQuantity(amount);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(LazyPacketData.simpleInt((String)"NewQuantity", (int)amount));
            }
        }
    }

    public void setPrice(MoneyValue price) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(LazyPacketData.simpleMoneyValue((String)"NewPrice", (MoneyValue)price));
            }
        }
    }

    public void setFluid(FluidStack fluid) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            FluidTraderData fluidTrader;
            trade.setProduct(fluid);
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
            TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
            if (traderData instanceof FluidTraderData && (fluidTrader = (FluidTraderData)traderData).getStorage().refactorTanks()) {
                fluidTrader.markStorageDirty();
            }
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(LazyPacketData.simpleTag((String)"NewFluid", (CompoundTag)fluid.writeToNBT(new CompoundTag())));
            }
        }
    }

    public void OpenMessage(@Nonnull LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            this.tradeIndex = message.getInt("TradeIndex");
        }
    }

    public void receiveMessage(LazyPacketData message) {
        if (message.contains("NewFluid")) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)message.getNBT("NewFluid")));
        } else if (message.contains("NewQuantity")) {
            this.setQuantity(message.getInt("NewQuantity"));
        } else if (message.contains("NewPrice")) {
            this.setPrice(message.getMoneyValue("NewPrice"));
        } else if (message.contains("NewType")) {
            this.setType(TradeDirection.fromIndex((int)message.getInt("NewType")));
        }
    }
}

