/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.notifications.types;

import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.SingleLineTaxableNotification;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxableNotification;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class FluidTradeNotification
extends SingleLineTaxableNotification {
    public static final NotificationType<FluidTradeNotification> TYPE = new NotificationType(new ResourceLocation("lctech", "fluid_trade"), FluidTradeNotification::new);
    TraderCategory traderData;
    TradeDirection tradeType;
    Component fluidName;
    int fluidCount;
    MoneyValue cost = MoneyValue.empty();
    String customer;

    private FluidTradeNotification() {
    }

    protected FluidTradeNotification(FluidTradeData trade, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.tradeType = trade.getTradeDirection();
        this.fluidName = FluidFormatUtil.getFluidName(trade.getProduct()).m_130948_(Style.f_131099_);
        this.fluidCount = trade.getQuantity();
        this.cost = cost;
        this.customer = customer.getName(false);
    }

    public static Supplier<Notification> create(FluidTradeData trade, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        return () -> new FluidTradeNotification(trade, cost, customer, traderData, taxesPaid);
    }

    @Nonnull
    protected NotificationType<FluidTradeNotification> getType() {
        return TYPE;
    }

    @Nonnull
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Nonnull
    public MutableComponent getNormalMessage() {
        MutableComponent boughtText = this.tradeType.getActionPhrase();
        MutableComponent fluidText = TechText.NOTIFICATION_FLUID_FORMAT.get(new Object[]{FluidFormatUtil.formatFluidAmount(this.fluidCount), this.fluidName});
        MutableComponent cost = this.cost.getText("0");
        return TechText.NOTIFICATION_TRADE_FLUID.get(new Object[]{this.customer, boughtText, fluidText, cost});
    }

    protected void saveNormal(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("TradeType", this.tradeType.index);
        compound.m_128359_("Fluid", Component.Serializer.m_130703_((Component)this.fluidName));
        compound.m_128405_("FluidCount", this.fluidCount);
        compound.m_128365_("Price", (Tag)this.cost.save());
        compound.m_128359_("Customer", this.customer);
    }

    protected void loadNormal(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.tradeType = TradeDirection.fromIndex((int)compound.m_128451_("TradeType"));
        this.fluidName = Component.Serializer.m_130701_((String)compound.m_128461_("Fluid"));
        this.fluidCount = compound.m_128451_("FluidCount");
        this.cost = MoneyValue.safeLoad((CompoundTag)compound, (String)"Price");
        this.customer = compound.m_128461_("Customer");
    }

    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof FluidTradeNotification) {
            FluidTradeNotification ftn = (FluidTradeNotification)other;
            if (!ftn.traderData.matches((NotificationCategory)this.traderData)) {
                return false;
            }
            if (ftn.tradeType != this.tradeType) {
                return false;
            }
            if (!ftn.fluidName.getString().equals(this.fluidName.getString())) {
                return false;
            }
            if (ftn.fluidCount != this.fluidCount) {
                return false;
            }
            if (!ftn.cost.equals((Object)this.cost)) {
                return false;
            }
            if (!ftn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch((TaxableNotification)ftn);
        }
        return false;
    }
}

