/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.client.gui.TechSprites;
import io.github.lightman314.lctech.client.util.FluidRenderUtil;
import io.github.lightman314.lctech.common.core.ModBlocks;
import io.github.lightman314.lctech.common.menu.traderstorage.fluid.FluidStorageTab;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NormalSprite;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidStorageClientTab
extends TraderStorageClientTab<FluidStorageTab>
implements IScrollable,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int TANKS = 8;
    int scroll = 0;
    ScrollBarWidget scrollBar;

    public FluidStorageClientTab(Object screen, FluidStorageTab tab) {
        super(screen, (TraderStorageTab)tab);
    }

    public IconData getIcon() {
        return ItemIcon.ofItem(ModBlocks.IRON_TANK);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_STORAGE.get(new Object[0]);
    }

    public boolean blockInventoryClosing() {
        return false;
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.scrollBar = (ScrollBarWidget)this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(157, 17))).height(90).scrollable((IScrollable)this).build());
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos)).size(screenArea.width, 118)).listener((IScrollable)this).build());
    }

    public void renderBG(EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.TOOLTIP_TRADER_STORAGE.get(new Object[0]), 8, 6, 0x404040);
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            this.validateScroll();
            int index = this.scroll;
            TraderFluidStorage storage = trader.getStorage();
            int yPos = 17;
            for (int x = 0; x < 8 && index < storage.getTanks(); ++index, ++x) {
                int n = 13 + x * 18;
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(index);
                gui.renderItem(FluidItemUtil.getFluidDisplayItem(entry.filter), n + 1, yPos);
                gui.resetColor();
                if (trader.drainCapable()) {
                    NormalSprite drainSprite = entry.drainable ? TechSprites.DRAINABLE_ACTIVE : TechSprites.DRAINABLE_INACTIVE;
                    drainSprite.render(gui, n + 1, yPos + 16);
                    FixedSizeSprite fillSprite = entry.fillable ? TechSprites.FILLABLE_ACTIVE : TechSprites.FILLABLE_INACTIVE;
                    fillSprite.render(gui, n + 9, yPos + 16);
                }
                TechSprites.TANK_BACKGROUND.render(gui, n, yPos + 24, 66);
                FluidRenderUtil.drawFluidTankInGUI(entry.filter, ((ITraderStorageScreen)this.screen).getCorner(), n + 1, yPos + 25, 16, 64, (float)entry.getStoredAmount() / (float)storage.getTankCapacity());
                gui.resetColor();
                TechSprites.TANK_FOREGROUND.render(gui, n, yPos + 24, 66);
            }
            gui.resetColor();
            for (Slot slot : ((FluidStorageTab)this.commonTab).getSlots()) {
                gui.renderSlot((IEasyScreen)this.screen, slot);
            }
        }
    }

    public void renderAfterWidgets(EasyGuiGraphics gui) {
        if (((ITraderStorageMenu)this.menu).getTrader() instanceof FluidTraderData) {
            Pair<Integer, Boolean> hoveredToggle;
            TraderFluidStorage storage = ((FluidTraderData)((ITraderStorageMenu)this.menu).getTrader()).getStorage();
            int hoveredSlot = this.isMouseOverTank(gui.mousePos);
            if (hoveredSlot >= 0) {
                if ((hoveredSlot += this.scroll) < 0 || hoveredSlot >= storage.getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(hoveredSlot);
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                tooltips.add(FluidFormatUtil.getFluidName(entry.filter));
                tooltips.add(EasyText.literal((String)(FluidFormatUtil.formatFluidAmount(entry.getStoredAmount()) + "mB/" + FluidFormatUtil.formatFluidAmount(storage.getTankCapacity()) + "mB")).withStyle(ChatFormatting.GRAY));
                if (entry.hasPendingDrain()) {
                    tooltips.add(TechText.TOOLTIP_FLUID_PENDING_DRAIN.get(new Object[]{FluidFormatUtil.formatFluidAmount(entry.getPendingDrain())}));
                }
                tooltips.add(TechText.TOOLTIP_FLUID_INTERACT.get(new Object[0]));
                gui.renderComponentTooltip(tooltips);
            }
            if ((hoveredToggle = this.isMouseOverDrainFill(gui.mousePos)) != null) {
                int tank = (Integer)hoveredToggle.getFirst() + this.scroll;
                boolean drainState = (Boolean)hoveredToggle.getSecond();
                if (tank < 0 || tank >= storage.getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(tank);
                if (drainState) {
                    gui.renderTooltip((Component)(entry.drainable ? TechText.TOOLTIP_FLUID_SETTINGS_DRAIN_ENABLED.getWithStyle(new ChatFormatting[]{ChatFormatting.GREEN}) : TechText.TOOLTIP_FLUID_SETTINGS_DRAIN_DISABLED.getWithStyle(new ChatFormatting[]{ChatFormatting.RED})));
                } else {
                    gui.renderTooltip((Component)(entry.fillable ? TechText.TOOLTIP_FLUID_SETTINGS_FILL_ENABLED.getWithStyle(new ChatFormatting[]{ChatFormatting.GREEN}) : TechText.TOOLTIP_FLUID_SETTINGS_FILL_DISABLED.getWithStyle(new ChatFormatting[]{ChatFormatting.RED})));
                }
            }
        }
    }

    private Pair<Integer, Boolean> isMouseOverDrainFill(ScreenPosition mousePos) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (!trader.drainCapable()) {
                return null;
            }
            int leftEdge = ((ITraderStorageScreen)this.screen).getGuiLeft() + 13;
            int topEdge = ((ITraderStorageScreen)this.screen).getGuiTop() + 17 + 16;
            if (mousePos.y < topEdge || mousePos.y >= topEdge + 8) {
                return null;
            }
            for (int x = 0; x < 8; ++x) {
                if (mousePos.x >= leftEdge + x * 18 + 1 && mousePos.x < leftEdge + x * 18 + 9) {
                    return Pair.of((Object)x, (Object)true);
                }
                if (mousePos.x < leftEdge + x * 18 + 9 || mousePos.x >= leftEdge + x * 18 + 17) continue;
                return Pair.of((Object)x, (Object)false);
            }
        }
        return null;
    }

    private int isMouseOverTank(ScreenPosition mousePos) {
        int leftEdge = ((ITraderStorageScreen)this.screen).getGuiLeft() + 13;
        int topEdge = ((ITraderStorageScreen)this.screen).getGuiTop() + 17 + 24;
        if (mousePos.y < topEdge || mousePos.y >= topEdge + 66) {
            return -1;
        }
        for (int x = 0; x < 8; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            return x;
        }
        return -1;
    }

    private int totalTankSlots() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            return trader.getStorage().getTanks();
        }
        return 0;
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            ScreenPosition mousePos = ScreenPosition.of((double)mouseX, (double)mouseY);
            int hoveredSlot = this.isMouseOverTank(mousePos);
            if (hoveredSlot >= 0) {
                ((FluidStorageTab)this.commonTab).interactWithTank(hoveredSlot += this.scroll, Screen.hasShiftDown());
                return true;
            }
            Pair<Integer, Boolean> hoveredToggle = this.isMouseOverDrainFill(mousePos);
            if (hoveredToggle != null) {
                int tank = (Integer)hoveredToggle.getFirst() + this.scroll;
                boolean drainState = (Boolean)hoveredToggle.getSecond();
                TraderFluidStorage storage = trader.getStorage();
                if (tank < 0 || tank >= storage.getTanks()) {
                    return false;
                }
                boolean currentState = drainState ? storage.getContents().get((int)tank).drainable : storage.getContents().get((int)tank).fillable;
                ((FluidStorageTab)this.commonTab).toggleDrainFillState(tank, (Boolean)hoveredToggle.getSecond(), !currentState);
                return true;
            }
        }
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public int currentScroll() {
        return this.scroll;
    }

    public int getMaxScroll() {
        return Math.max(0, this.totalTankSlots() - 8);
    }

    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Nullable
    public Pair<FluidStack, ScreenArea> getHoveredFluid(ScreenPosition mousePos) {
        TraderData traderData;
        int leftEdge = ((ITraderStorageScreen)this.screen).getGuiLeft() + 13;
        int topEdge = ((ITraderStorageScreen)this.screen).getGuiTop() + 17 + 24;
        if (mousePos.y < topEdge || mousePos.y >= topEdge + 66) {
            return null;
        }
        int tankIndex = -1;
        for (int x = 0; x < 8; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            tankIndex = x;
        }
        if (tankIndex >= 0 && (traderData = ((ITraderStorageMenu)this.menu).getTrader()) instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            FluidStack contents = trader.getStorage().getFluidInTank(tankIndex + this.scroll);
            if (contents.isEmpty()) {
                return null;
            }
            return Pair.of((Object)contents, (Object)ScreenArea.of((int)(leftEdge + tankIndex * 18), (int)topEdge, (int)18, (int)66));
        }
        return super.getHoveredFluid(mousePos);
    }
}

