/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid;

import io.github.lightman314.lctech.client.gui.widget.FluidEditWidget;
import io.github.lightman314.lctech.common.menu.traderstorage.fluid.FluidTradeEditTab;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionHandler;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidTradeEditClientTab
extends TraderStorageClientTab<FluidTradeEditTab>
implements TradeInteractionHandler,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 71;
    private static final int COLUMNS = 10;
    private static final int ROWS = 2;
    TradeButton tradeDisplay;
    MoneyValueWidget priceSelection;
    EasyButton buttonAddBucket;
    EasyButton buttonRemoveBucket;
    FluidEditWidget fluidEdit;
    EasyButton buttonToggleTradeType;
    private int selection;

    public FluidTradeEditClientTab(Object screen, FluidTradeEditTab commonTab) {
        super(screen, (TraderStorageTab)commonTab);
    }

    public IconData getIcon() {
        return IconUtil.ICON_TRADER;
    }

    public MutableComponent getTooltip() {
        return EasyText.empty();
    }

    public boolean tabVisible() {
        return false;
    }

    public boolean blockInventoryClosing() {
        return true;
    }

    public int getTradeRuleTradeIndex() {
        return ((FluidTradeEditTab)this.commonTab).getTradeIndex();
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild((Object)this);
        FluidTradeData trade = this.getTrade();
        this.tradeDisplay = (TradeButton)this.addChild(((TradeButton.Builder)TradeButton.builder().position(screenArea.pos.offset(10, 18))).context(() -> ((ITraderStorageMenu)((ITraderStorageMenu)this.menu)).getContext()).trade(((FluidTradeEditTab)this.commonTab)::getTrade).build());
        this.priceSelection = (MoneyValueWidget)this.addChild(((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 88, 40))).oldIfNotFirst(firstOpen, this.priceSelection).startingValue((TradeData)trade).valueHandler(this::onValueChanged).build());
        this.fluidEdit = (FluidEditWidget)((Object)this.addChild((Object)((FluidEditWidget.Builder)FluidEditWidget.builder().position(screenArea.pos.offset(13, 71))).columns(10).rows(2).handler(this::onFluidClicked).build()));
        this.buttonAddBucket = (EasyButton)this.addChild(((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(74, 38))).pressAction(this::ChangeQuantity)).icon(IconUtil.ICON_PLUS).build());
        this.buttonRemoveBucket = (EasyButton)this.addChild(((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(113, 38))).pressAction(this::ChangeQuantity)).icon(IconUtil.ICON_PLUS).build());
        this.buttonToggleTradeType = (EasyButton)this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(113, 15))).width(80)).text(() -> this.getTrade().getTradeDirection().getName()).pressAction(this::ToggleTradeType)).build());
    }

    public void closeAction() {
        this.selection = -1;
    }

    public void renderBG(EasyGuiGraphics gui) {
        if (this.getTrade() == null) {
            return;
        }
        this.validateRenderables();
        if (this.selection >= 0) {
            String quantityText = this.getTrade().getBucketQuantity() + "B";
            int textWidth = gui.font.width(quantityText);
            gui.drawString(quantityText, 1 + ((ITraderStorageScreen)this.screen).getXSize() / 2 - textWidth / 2, 42, 0xFFFFFF);
        }
        gui.resetColor();
        SpriteUtil.SMALL_ARROW_DOWN.render(gui, this.getArrowPosition(), 10);
    }

    private int getArrowPosition() {
        FluidTradeData trade = this.getTrade();
        if (this.selection == -1) {
            if (trade.isSale()) {
                return 25;
            }
            return 63;
        }
        if (trade.isSale()) {
            return 72;
        }
        return 16;
    }

    private void validateRenderables() {
        this.priceSelection.visible = this.selection < 0;
        this.fluidEdit.visible = this.selection >= 0;
        this.buttonRemoveBucket.visible = this.selection >= 0;
        this.buttonAddBucket.visible = this.buttonRemoveBucket.visible;
        if (this.buttonAddBucket.visible) {
            boolean bl = this.buttonAddBucket.active = this.getTrade().getBucketQuantity() < this.getTrade().getMaxBucketQuantity();
        }
        if (this.buttonRemoveBucket.visible) {
            this.buttonRemoveBucket.active = this.getTrade().getBucketQuantity() > 1;
        }
    }

    public void OpenMessage(LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            ((FluidTradeEditTab)this.commonTab).setTradeIndex(message.getInt("TradeIndex"));
        }
        if (message.contains("StartingSlot")) {
            this.selection = message.getInt("StartingSlot");
        }
    }

    public void HandleTradeInputInteraction(TraderData traderData, TradeData trade, TradeInteractionData tradeInteractionData, int i) {
        if (trade instanceof FluidTradeData) {
            FluidTradeData t = (FluidTradeData)trade;
            ItemStack heldItem = ((ITraderStorageMenu)this.menu).getHeldItem();
            if (t.isSale()) {
                this.changeSelection(-1);
            } else if (t.isPurchase()) {
                if (this.selection != 0 && heldItem.isEmpty()) {
                    this.changeSelection(0);
                } else {
                    ((FluidTradeEditTab)this.commonTab).setFluid(FluidUtil.getFluidContained((ItemStack)heldItem).orElse(FluidStack.EMPTY));
                }
            }
        }
    }

    public void HandleTradeOutputInteraction(TraderData traderData, TradeData trade, TradeInteractionData tradeInteractionData, int i) {
        if (trade instanceof FluidTradeData) {
            FluidTradeData t = (FluidTradeData)trade;
            ItemStack heldItem = ((ITraderStorageMenu)this.menu).getHeldItem();
            if (t.isSale()) {
                if (this.selection != 0 && heldItem.isEmpty()) {
                    this.changeSelection(0);
                } else {
                    ((FluidTradeEditTab)this.commonTab).setFluid(FluidUtil.getFluidContained((ItemStack)heldItem).orElse(FluidStack.EMPTY));
                }
            } else if (t.isPurchase()) {
                this.changeSelection(-1);
            }
        }
    }

    public void HandleOtherTradeInteraction(TraderData traderData, TradeData tradeData, TradeInteractionData tradeInteractionData) {
    }

    private void changeSelection(int newSelection) {
        this.selection = newSelection;
        if (this.selection == -1) {
            this.priceSelection.changeValue(this.getTrade().getCost());
        }
        if (this.selection == 0 && !this.getTrade().isSale()) {
            this.fluidEdit.refreshSearch();
        }
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.HandleInteractionClick((int)mouseX, (int)mouseY, button, (TradeInteractionHandler)this);
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public void onValueChanged(MoneyValue value) {
        ((FluidTradeEditTab)this.commonTab).setPrice(value);
    }

    public FluidTradeData getTrade() {
        return ((FluidTradeEditTab)this.commonTab).getTrade();
    }

    public void onFluidClicked(FluidStack fluid) {
        ((FluidTradeEditTab)this.commonTab).setFluid(fluid);
    }

    private void ChangeQuantity(EasyButton button) {
        if (this.getTrade() != null) {
            int deltaQuantity = 1;
            if (button == this.buttonRemoveBucket) {
                deltaQuantity = -1;
            }
            ((FluidTradeEditTab)this.commonTab).setQuantity(this.getTrade().getBucketQuantity() + deltaQuantity);
        }
    }

    private void ToggleTradeType(EasyButton button) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            ((FluidTradeEditTab)this.commonTab).setType(trade.isSale() ? TradeDirection.PURCHASE : TradeDirection.SALE);
        }
    }
}

