/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.common.blockentities.handler.EnergyInterfaceHandler;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.menu.traderinterface.energy.EnergyStorageTab;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.upgrades.TechUpgradeTypes;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.data.TradeReference;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.tabbed.EasyMenuTab;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyTraderInterfaceBlockEntity
extends TraderInterfaceBlockEntity {
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{TechUpgradeTypes.ENERGY_CAPACITY});
    EnergyInterfaceHandler energyHandler = (EnergyInterfaceHandler)this.addHandler((SidedHandler)new EnergyInterfaceHandler(this));
    int energyStorage = 0;

    public EnergyInterfaceHandler getEnergyHandler() {
        return this.energyHandler;
    }

    public int getStoredEnergy() {
        return this.energyStorage;
    }

    public void addStoredEnergy(int amount) {
        this.energyStorage += amount;
        this.setEnergyBufferDirty();
    }

    public void drainStoredEnergy(int amount) {
        this.energyStorage -= amount;
        this.setEnergyBufferDirty();
    }

    public int getMaxEnergy() {
        int defaultCapacity;
        int capacity = defaultCapacity = EnergyTraderData.getDefaultMaxEnergy();
        boolean baseStorageCompensation = false;
        for (int i = 0; i < this.getUpgrades().getContainerSize(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            int addAmount = UpgradeItem.getUpgradeData((ItemStack)stack).getIntValue(CapacityUpgrade.CAPACITY);
            if (addAmount > defaultCapacity && !baseStorageCompensation) {
                addAmount -= defaultCapacity;
                baseStorageCompensation = true;
            }
            capacity += addAmount;
        }
        return capacity;
    }

    public EnergyTraderInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.TRADER_INTERFACE_ENERGY.get(), pos, state);
    }

    public List<TraderInterfaceBlockEntity.InteractionType> getBlacklistedInteractions() {
        return Lists.newArrayList((Object[])new TraderInterfaceBlockEntity.InteractionType[]{TraderInterfaceBlockEntity.InteractionType.RESTOCK_AND_DRAIN});
    }

    public TradeContext.Builder buildTradeContext(TradeContext.Builder baseContext) {
        return baseContext.withEnergyHandler(this.energyHandler.tradeHandler);
    }

    public TradeData deserializeTrade(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        return EnergyTradeData.loadData(compound, false, lookup);
    }

    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.saveAdditional(compound, lookup);
        this.saveEnergyBuffer(compound);
    }

    protected final CompoundTag saveEnergyBuffer(CompoundTag compound) {
        compound.putInt("Energy", this.energyStorage);
        return compound;
    }

    public void setEnergyBufferDirty() {
        this.setChanged();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, (CompoundTag)this.saveEnergyBuffer(new CompoundTag()));
        }
    }

    public void loadAdditional(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.loadAdditional(compound, lookup);
        if (compound.contains("Energy")) {
            this.energyStorage = compound.getInt("Energy");
        }
    }

    public boolean validTraderType(TraderData trader) {
        return trader instanceof EnergyTraderData;
    }

    protected void drainTick(@Nonnull TraderData t) {
        int drainableAmount;
        EnergyTraderData trader;
        if (t instanceof EnergyTraderData && (trader = (EnergyTraderData)t).hasPermission(this.getReferencedPlayer(), "interactionLink") && (drainableAmount = Math.min(this.getMaxEnergy() - this.getStoredEnergy(), trader.getAvailableEnergy())) > 0) {
            drainableAmount = Math.min(drainableAmount, (Integer)TechConfig.SERVER.energyRestockSpeed.get());
            trader.shrinkEnergy(drainableAmount);
            trader.markEnergyStorageDirty();
            this.addStoredEnergy(drainableAmount);
        }
    }

    protected void restockTick(@Nonnull TraderData t) {
        int restockableAmount;
        EnergyTraderData trader;
        if (t instanceof EnergyTraderData && (trader = (EnergyTraderData)t).hasPermission(this.getReferencedPlayer(), "interactionLink") && (restockableAmount = Math.min(this.getStoredEnergy(), trader.getMaxEnergy() - trader.getTotalEnergy())) > 0) {
            restockableAmount = Math.min(restockableAmount, (Integer)TechConfig.SERVER.energyRestockSpeed.get());
            trader.addEnergy(restockableAmount);
            trader.markEnergyStorageDirty();
            this.drainStoredEnergy(restockableAmount);
        }
    }

    protected void tradeTick(@Nonnull TradeReference tr) {
        EnergyTradeData trade;
        TradeData t = tr.getTrueTrade();
        if (t instanceof EnergyTradeData && (trade = (EnergyTradeData)t) != null && trade.isValid()) {
            if (trade.isSale()) {
                if (this.getMaxEnergy() - this.energyStorage >= trade.getAmount() && this.TryExecuteTrade(tr).isSuccess()) {
                    this.setEnergyBufferDirty();
                }
            } else if (trade.isPurchase() && this.energyStorage >= trade.getAmount() && this.TryExecuteTrade(tr).isSuccess()) {
                this.setEnergyBufferDirty();
            }
        }
    }

    public void serverTick() {
        super.serverTick();
        if (this.energyStorage > 0) {
            for (Direction direction : Direction.values()) {
                int extractedAmount;
                Direction trueSide;
                IEnergyStorage energyHandler;
                if (!this.energyHandler.allowOutputSide(direction) || this.energyStorage <= 0 || (energyHandler = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.worldPosition.relative(trueSide = this.getBlockState().getBlock() instanceof IRotatableBlock ? IRotatableBlock.getActualSide((Direction)((IRotatableBlock)this.getBlockState().getBlock()).getFacing(this.getBlockState()), (Direction)direction) : direction), (Object)trueSide.getOpposite())) == null || (extractedAmount = energyHandler.receiveEnergy(this.energyStorage, false)) <= 0) continue;
                this.drainStoredEnergy(extractedAmount);
            }
        }
    }

    protected void hopperTick() {
        AtomicBoolean markBufferDirty = new AtomicBoolean(false);
        for (Direction relativeSide : Direction.values()) {
            int extractedAmount;
            BlockPos queryPos;
            IEnergyStorage energyHandler;
            if (!this.energyHandler.allowInputSide(relativeSide)) continue;
            Direction actualSide = relativeSide;
            Block block = this.getBlockState().getBlock();
            if (block instanceof IRotatableBlock) {
                IRotatableBlock b = (IRotatableBlock)block;
                actualSide = IRotatableBlock.getActualSide((Direction)b.getFacing(this.getBlockState()), (Direction)relativeSide);
            }
            if ((energyHandler = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, queryPos = this.worldPosition.relative(actualSide), (Object)actualSide.getOpposite())) == null || (extractedAmount = energyHandler.extractEnergy(this.getMaxEnergy() - this.energyStorage, false)) <= 0) continue;
            this.energyStorage += extractedAmount;
            markBufferDirty.set(true);
        }
        if (markBufferDirty.get()) {
            this.setEnergyBufferDirty();
        }
    }

    public void initMenuTabs(TraderInterfaceMenu menu) {
        menu.setTab(1, (EasyMenuTab)new EnergyStorageTab(menu));
    }

    public boolean allowAdditionalUpgrade(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public void getAdditionalContents(List<ItemStack> contents) {
    }
}

