/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities.fluid_tank;

import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.FluidTankFluidHandler;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.TankStackCache;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.TankStackState;
import io.github.lightman314.lctech.common.blocks.FluidTankBlock;
import io.github.lightman314.lctech.common.blocks.IFluidTankBlock;
import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.items.FluidTankItem;
import io.github.lightman314.lctech.network.message.fluid_tank.CMessageRequestTankStackSync;
import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class FluidTankBlockEntity
extends EasyBlockEntity
implements IServerTicker {
    public static final int DEFAULT_CAPACITY = 10000;
    FluidStack tankContents = FluidStack.EMPTY;
    private boolean refactorTankStack = false;
    private TankStackCache stackCache = TankStackCache.DUMMY;
    public final FluidTankFluidHandler handler = new FluidTankFluidHandler(this);

    public FluidStack getTankContents() {
        return this.tankContents;
    }

    public void setTankContents(@NotNull FluidStack newContents) {
        this.tankContents = newContents;
        this.setChanged();
    }

    public int getTankCapacity() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof FluidTankBlock) {
            FluidTankBlock tankBlock = (FluidTankBlock)block;
            return tankBlock.getTankCapacity();
        }
        return 10000;
    }

    public double getTankFillPercent() {
        return (double)this.tankContents.getAmount() / (double)this.getTankCapacity();
    }

    public final void setTankStack(TankStackCache tankStack) {
        this.refactorTankStack = false;
        TankStackCache oldStack = this.stackCache;
        this.stackCache = tankStack;
        oldStack.refactorExcluded(this.stackCache);
    }

    public final void sendTankStackPacket(Player player) {
        this.stackCache.getSyncPacket().sendTo(player);
    }

    public FluidTankBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntities.FLUID_TANK.get(), pos, state);
    }

    protected FluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nonnull
    public ItemInteractionResult onInteraction(@Nonnull ItemStack heldItem, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (FluidUtil.getFluidHandler((ItemStack)heldItem).isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)heldItem, (IFluidHandler)this.handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        if (result.isSuccess()) {
            if (player.isCreative() && (result.getResult().getItem() == Items.BUCKET || heldItem.getItem() == Items.BUCKET)) {
                return ItemInteractionResult.SUCCESS;
            }
            if (heldItem.getCount() > 1) {
                heldItem.shrink(1);
                player.setItemInHand(hand, heldItem);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result.getResult());
            } else {
                player.setItemInHand(hand, result.getResult());
            }
        } else {
            result = FluidUtil.tryFillContainer((ItemStack)heldItem, (IFluidHandler)this.handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (result.isSuccess()) {
                if (player.isCreative() && (result.getResult().getItem() == Items.BUCKET || heldItem.getItem() == Items.BUCKET)) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (heldItem.getCount() > 1) {
                    heldItem.shrink(1);
                    player.setItemInHand(hand, heldItem);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result.getResult());
                } else {
                    player.setItemInHand(hand, result.getResult());
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void setChanged() {
        assert (this.level != null);
        if (!this.level.isClientSide) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this);
            super.setChanged();
        }
    }

    public void saveAdditional(CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        tag.put("Tank", this.tankContents.saveOptional(lookup));
        super.saveAdditional(tag, lookup);
    }

    public void loadAdditional(CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        if (tag.contains("Tank", 10)) {
            this.tankContents = FluidStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)tag.getCompound("Tank"));
        }
        super.loadAdditional(tag, lookup);
    }

    public void loadFromItem(ItemStack stack) {
        this.tankContents = FluidTankItem.GetFluid(stack);
        assert (this.level != null);
        if (!this.level.isClientSide) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this);
        }
        this.setChanged();
    }

    public FluidRenderData getRenderPosition() {
        Block block = this.level.getBlockState(this.worldPosition).getBlock();
        if (block instanceof IFluidTankBlock) {
            IFluidTankBlock tankBlock = (IFluidTankBlock)block;
            return tankBlock.getRenderData(this.level.getBlockState(this.worldPosition), this.stackCache.isLighterThanAir(), this, this.stackCache.getTankAbove(this));
        }
        return null;
    }

    public void onLoad() {
        assert (this.level != null);
        if (this.level.isClientSide) {
            BlockEntityUtil.requestUpdatePacket((Level)this.level, (BlockPos)this.worldPosition);
            new CMessageRequestTankStackSync(this.worldPosition).send();
        } else if (this.stackCache == TankStackCache.DUMMY) {
            this.enqueTankStackRefactor();
        }
    }

    public void serverTick() {
        if (this.refactorTankStack) {
            this.refactorTankStack = false;
            this.refactorTankStack();
        }
    }

    public final void enqueTankStackRefactor() {
        this.refactorTankStack = true;
    }

    public final void refactorTankStack() {
        FluidTankBlockEntity tank;
        BlockPos queryPos;
        BlockEntity be;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        int bottomY = this.worldPosition.getY();
        int topY = this.worldPosition.getY();
        FluidStack mostRelevantFluid = this.tankContents.copy();
        while ((be = this.level.getBlockEntity(queryPos = this.worldPosition.atY(bottomY - 1))) instanceof FluidTankBlockEntity && this.allowInStack(tank = (FluidTankBlockEntity)be, mostRelevantFluid)) {
            if (mostRelevantFluid.isEmpty()) {
                mostRelevantFluid = tank.getTankContents().copy();
            }
            bottomY = queryPos.getY();
        }
        while ((be = this.level.getBlockEntity(queryPos = this.worldPosition.atY(topY + 1))) instanceof FluidTankBlockEntity && this.allowInStack(tank = (FluidTankBlockEntity)be, mostRelevantFluid)) {
            if (mostRelevantFluid.isEmpty()) {
                mostRelevantFluid = tank.getTankContents().copy();
            }
            topY = queryPos.getY();
        }
        if (bottomY == topY) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)FluidTankBlock.TANK_STATE, (Comparable)((Object)TankStackState.SOLO)));
            TankStackCache.solo(this).init(true);
        } else {
            this.level.setBlockAndUpdate(this.worldPosition.atY(bottomY), (BlockState)this.level.getBlockState(this.worldPosition.atY(bottomY)).setValue((Property)FluidTankBlock.TANK_STATE, (Comparable)((Object)TankStackState.BOTTOM)));
            this.level.setBlockAndUpdate(this.worldPosition.atY(topY), (BlockState)this.level.getBlockState(this.worldPosition.atY(topY)).setValue((Property)FluidTankBlock.TANK_STATE, (Comparable)((Object)TankStackState.TOP)));
            for (int y = bottomY + 1; y < topY; ++y) {
                BlockPos middlePos = new BlockPos(this.worldPosition.getX(), y, this.worldPosition.getZ());
                this.level.setBlockAndUpdate(middlePos, (BlockState)this.level.getBlockState(middlePos).setValue((Property)FluidTankBlock.TANK_STATE, (Comparable)((Object)TankStackState.MIDDLE)));
            }
            TankStackCache.create(this.level, this.worldPosition, bottomY, topY).init(true);
        }
    }

    private boolean allowInStack(FluidTankBlockEntity tank, FluidStack mostRelevantFluid) {
        if (tank.getBlockState().getBlock() != this.getBlockState().getBlock()) {
            return false;
        }
        FluidStack contents = tank.getTankContents();
        return FluidStack.isSameFluidSameComponents((FluidStack)contents, (FluidStack)mostRelevantFluid) || contents.isEmpty() || mostRelevantFluid.isEmpty();
    }

    public final List<FluidTankBlockEntity> getTankStack() {
        return this.stackCache.getOrderedTanks();
    }

    public final List<FluidTankBlockEntity> getTankStack(FluidStack fluid) {
        return this.stackCache.getOrderedTanks(fluid);
    }
}

