/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities.trader;

import io.github.lightman314.lctech.common.core.ModBlockEntities;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyTraderBlockEntity
extends TraderBlockEntity<EnergyTraderData> {
    protected boolean networkTrader;

    public EnergyTraderBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, false);
    }

    public EnergyTraderBlockEntity(BlockPos pos, BlockState state, boolean networkTrader) {
        super(ModBlockEntities.ENERGY_TRADER.get(), pos, state);
        this.networkTrader = networkTrader;
    }

    @Nullable
    protected EnergyTraderData castOrNullify(@Nonnull TraderData traderData) {
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData et = (EnergyTraderData)traderData;
            return et;
        }
        return null;
    }

    @Nonnull
    public EnergyTraderData buildNewTrader() {
        EnergyTraderData trader = new EnergyTraderData(this.level, this.worldPosition);
        if (this.networkTrader) {
            trader.setAlwaysShowOnTerminal();
        }
        return trader;
    }

    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.saveAdditional(compound, lookup);
        compound.putBoolean("NetworkTrader", this.networkTrader);
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.loadAdditional(compound, lookup);
        this.networkTrader = compound.getBoolean("NetworkTrader");
    }

    public void serverTick() {
        super.serverTick();
        EnergyTraderData trader = (EnergyTraderData)this.getTraderData();
        if (trader != null && trader.canDrainExternally() && trader.getDrainableEnergy() > 0) {
            for (Direction relativeSide : Direction.values()) {
                int extractedAmount;
                IEnergyStorage energyHandler;
                if (!trader.allowOutputSide(relativeSide) || trader.getDrainableEnergy() <= 0) continue;
                Direction actualSide = relativeSide;
                Block block = this.getBlockState().getBlock();
                if (block instanceof IRotatableBlock) {
                    IRotatableBlock b = (IRotatableBlock)block;
                    actualSide = IRotatableBlock.getActualSide((Direction)b.getFacing(this.getBlockState()), (Direction)relativeSide);
                }
                if ((energyHandler = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.worldPosition.relative(actualSide), (Object)actualSide.getOpposite())) == null || (extractedAmount = energyHandler.receiveEnergy(trader.getDrainableEnergy(), false)) <= 0) continue;
                if (trader.isPurchaseDrainMode()) {
                    trader.shrinkPendingDrain(extractedAmount);
                }
                trader.shrinkEnergy(extractedAmount);
                trader.markEnergyStorageDirty();
            }
        }
    }
}

