/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blocks;

import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lightmanscurrency.common.blocks.EasyBlock;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class VoidTankBlock
extends EasyBlock {
    public static final IFluidHandler VOID_HANDLER = new VoidFluidHandler();

    public VoidTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack heldItem, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (hit.getDirection().getAxis().isVertical()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)heldItem, (IFluidHandler)VOID_HANDLER, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        if (result.isSuccess()) {
            if (heldItem.getCount() > 1) {
                heldItem.shrink(1);
                player.setItemInHand(hand, heldItem);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result.getResult());
            } else {
                player.setItemInHand(hand, result.getResult());
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(heldItem, state, level, pos, player, hand, hit);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)TechText.TOOLTIP_VOID_TANK.getWithStyle(new ChatFormatting[]{ChatFormatting.GRAY}));
    }

    private static class VoidFluidHandler
    implements IFluidHandler {
        private VoidFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int i) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int i) {
            return 0x3FFFFFFF;
        }

        public boolean isFluidValid(int i, @Nonnull FluidStack fluidStack) {
            return true;
        }

        public int fill(FluidStack fluidStack, @Nonnull IFluidHandler.FluidAction fluidAction) {
            return fluidStack.getAmount();
        }

        @Nonnull
        public FluidStack drain(@Nonnull FluidStack fluidStack, @Nonnull IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int i, @Nonnull IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }
    }
}

