/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.common.core.ModDataComponents;
import io.github.lightman314.lctech.common.core.ModItems;
import io.github.lightman314.lctech.common.items.data.FluidData;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidShardItem
extends Item {
    public static final ResourceLocation DATA = VersionUtil.modResource((String)"lctech", (String)"fluid_shard");
    private static final List<FluidShardItem> SHARD_ITEMS = Lists.newArrayList();
    public final ResourceLocation renderData;

    @OnlyIn(value=Dist.CLIENT)
    public static List<ModelResourceLocation> getShardModelList() {
        ArrayList list = Lists.newArrayList();
        SHARD_ITEMS.forEach(shardItem -> list.add(new ModelResourceLocation(BuiltInRegistries.ITEM.getKey((Object)shardItem), "inventory")));
        return list;
    }

    public FluidShardItem(Item.Properties properties) {
        this(properties, DATA);
    }

    public FluidShardItem(Item.Properties properties, ResourceLocation renderData) {
        super(properties.stacksTo(1));
        this.renderData = renderData;
        SHARD_ITEMS.add(this);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        FluidStack fluid;
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (FluidShardItem.getData((ItemStack)stack).showTooltip && !(fluid = FluidShardItem.GetFluid(stack)).isEmpty()) {
            tooltip.add((Component)FluidFormatUtil.getFluidName(fluid));
            tooltip.add((Component)Component.literal((String)(FluidFormatUtil.formatFluidAmount(fluid.getAmount()) + "mB")).withStyle(ChatFormatting.GRAY));
        }
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (FluidShardItem.GetFluid(stack).isEmpty()) {
            stack.setCount(0);
        }
    }

    public static FluidStack GetFluid(ItemStack stack) {
        return FluidShardItem.getData(stack).getFluid();
    }

    public static ItemStack GetFluidShard(FluidStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack returnStack = new ItemStack((ItemLike)ModItems.FLUID_SHARD.get());
        FluidShardItem.WriteTankData(returnStack, stack);
        return returnStack;
    }

    @Nonnull
    private static FluidData getData(@Nonnull ItemStack stack) {
        return (FluidData)stack.getOrDefault(ModDataComponents.FLUID_DATA, (Object)FluidData.EMPTY);
    }

    public static void WriteTankData(ItemStack stack, FluidStack tank) {
        FluidData data = FluidShardItem.getData(stack);
        stack.set(ModDataComponents.FLUID_DATA, (Object)data.withFluid(tank));
    }

    public static IFluidHandlerItem createHandler(@Nonnull ItemStack stack) {
        if (stack.getItem() instanceof FluidShardItem) {
            return new FluidShardCapability(stack);
        }
        return null;
    }

    public static class FluidShardCapability
    implements IFluidHandlerItem {
        final ItemStack stack;

        private FluidStack tank() {
            return FluidShardItem.GetFluid(this.stack);
        }

        private void setTank(FluidStack tank) {
            FluidShardItem.WriteTankData(this.stack, tank);
        }

        public FluidShardCapability(ItemStack stack) {
            this.stack = stack;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? this.tank().copy() : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return this.getFluidInTank(tank).getAmount();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
            if (this.tank().isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)this.tank(), (FluidStack)resource)) {
                return FluidStack.EMPTY;
            }
            int drainAmount = MathUtil.clamp((int)resource.getAmount(), (int)0, (int)this.tank().getAmount());
            FluidStack resultStack = this.tank().copy();
            resultStack.setAmount(drainAmount);
            if (action.execute()) {
                FluidStack tank = this.tank();
                tank.shrink(drainAmount);
                if (tank.isEmpty()) {
                    tank = FluidStack.EMPTY;
                }
                this.setTank(tank);
                if (tank.isEmpty()) {
                    this.getContainer().shrink(1);
                }
            }
            return resultStack;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, @Nonnull IFluidHandler.FluidAction action) {
            if (this.tank().isEmpty()) {
                return FluidStack.EMPTY;
            }
            int drainAmount = MathUtil.clamp((int)maxDrain, (int)0, (int)this.tank().getAmount());
            FluidStack resultStack = this.tank().copy();
            resultStack.setAmount(drainAmount);
            if (action.execute()) {
                FluidStack tank = this.tank();
                tank.shrink(drainAmount);
                if (tank.isEmpty()) {
                    tank = FluidStack.EMPTY;
                }
                this.setTank(tank);
                if (tank.isEmpty()) {
                    this.getContainer().shrink(1);
                }
            }
            return resultStack;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.stack;
        }
    }
}

