/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.common.core.ModDataComponents;
import io.github.lightman314.lctech.common.items.data.BatteryData;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.energy.IEnergyStorage;

public interface IBatteryItem {
    public int getMaxEnergyStorage(ItemStack var1);

    public static IEnergyStorage createCapability(ItemStack stack) {
        if (stack.getItem() instanceof IBatteryItem) {
            return new BatteryEnergyStorage(stack);
        }
        LCTech.LOGGER.warn("Attempted to make a battery storage capability for an item that doesn't implement IBatteryItem.");
        return null;
    }

    public static int getStoredEnergy(ItemStack stack) {
        return IBatteryItem.getData(stack).energy();
    }

    @Nonnull
    public static BatteryData getData(@Nonnull ItemStack stack) {
        return (BatteryData)stack.getOrDefault(ModDataComponents.ENERGY_DATA, (Object)BatteryData.EMPTY);
    }

    public static <T extends IBatteryItem & ItemLike> ItemStack getFullBattery(T item) {
        ItemStack newStack = new ItemStack((ItemLike)item);
        BatteryData data = IBatteryItem.getData(newStack);
        newStack.set(ModDataComponents.ENERGY_DATA, (Object)data.withEnergy(item.getMaxEnergyStorage(newStack)));
        return newStack;
    }

    public static ItemStack HideEnergyBar(Supplier<? extends ItemLike> item) {
        return IBatteryItem.HideEnergyBar(new ItemStack(item.get()));
    }

    public static ItemStack HideEnergyBar(ItemLike item) {
        return IBatteryItem.HideEnergyBar(new ItemStack(item));
    }

    public static ItemStack HideEnergyBar(ItemStack stack) {
        BatteryData data = IBatteryItem.getData(stack);
        stack.set(ModDataComponents.ENERGY_DATA, (Object)data.withEnergyBarVisible(false));
        return stack;
    }

    public static boolean isEnergyBarVisible(ItemStack batteryStack) {
        if (batteryStack.getItem() instanceof IBatteryItem) {
            return IBatteryItem.getData(batteryStack).energyBarVisible();
        }
        return false;
    }

    public static class BatteryEnergyStorage
    implements IEnergyStorage {
        private final ItemStack stack;

        private BatteryEnergyStorage(ItemStack stack) {
            this.stack = stack;
            if (this.getEnergyStored() == 0) {
                this.setEnergyStored(0);
            }
        }

        private void setEnergyStored(int energyStored) {
            BatteryData data = IBatteryItem.getData(this.stack);
            this.stack.set(ModDataComponents.ENERGY_DATA, (Object)data.withEnergy(energyStored));
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int receiveAmount = Math.min(maxReceive, this.getMaxEnergyStored() - this.getEnergyStored());
            if (!simulate) {
                this.setEnergyStored(this.getEnergyStored() + receiveAmount);
            }
            return receiveAmount;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extractAmount = Math.min(maxExtract, this.getEnergyStored());
            if (!simulate) {
                this.setEnergyStored(this.getEnergyStored() - extractAmount);
            }
            return extractAmount;
        }

        public int getEnergyStored() {
            return IBatteryItem.getStoredEnergy(this.stack);
        }

        public int getMaxEnergyStored() {
            Item item = this.stack.getItem();
            if (item instanceof IBatteryItem) {
                IBatteryItem battery = (IBatteryItem)item;
                return battery.getMaxEnergyStorage(this.stack);
            }
            return 0;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

