/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VoidTankItem
extends BlockItem {
    public VoidTankItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static IFluidHandlerItem getVoidHandler(ItemStack stack) {
        return new VoidFluidHandler(stack);
    }

    private record VoidFluidHandler(ItemStack item) implements IFluidHandlerItem
    {
        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int i) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int i) {
            return 0x3FFFFFFF;
        }

        public boolean isFluidValid(int i, FluidStack fluidStack) {
            return true;
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return fluidStack.getAmount();
        }

        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }

        public ItemStack getContainer() {
            return this.item;
        }
    }
}

