/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record BatteryData(int energy, boolean tooltipVisible, boolean energyBarVisible) {
    public static final Codec<BatteryData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("Energy").forGetter(BatteryData::energy), (App)Codec.BOOL.optionalFieldOf("Tooltip", (Object)true).forGetter(BatteryData::tooltipVisible), (App)Codec.BOOL.optionalFieldOf("Visible", (Object)true).forGetter(BatteryData::energyBarVisible)).apply((Applicative)builder, BatteryData::new));
    public static final StreamCodec<FriendlyByteBuf, BatteryData> STREAM_CODEC = StreamCodec.of((b, d) -> {
        b.writeInt(d.energy);
        b.writeBoolean(d.tooltipVisible);
        b.writeBoolean(d.energyBarVisible);
    }, b -> new BatteryData(b.readInt(), b.readBoolean(), b.readBoolean()));
    public static final BatteryData EMPTY = new BatteryData(0, true, true);

    public BatteryData withEnergy(int energy) {
        return new BatteryData(energy, this.tooltipVisible, this.energyBarVisible);
    }

    public BatteryData withTooltipVisible(boolean tooltipVisible) {
        return new BatteryData(this.energy, tooltipVisible, this.energyBarVisible);
    }

    public BatteryData withEnergyBarVisible(boolean energyBarVisible) {
        return new BatteryData(this.energy, this.tooltipVisible, energyBarVisible);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.energy, this.tooltipVisible, this.energyBarVisible);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BatteryData) {
            BatteryData other = (BatteryData)obj;
            return other.energy == this.energy && other.tooltipVisible == this.tooltipVisible && other.energyBarVisible == this.energyBarVisible;
        }
        return false;
    }
}

