/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;

public final class FluidData {
    public static final Codec<FluidData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FluidStack.OPTIONAL_CODEC.fieldOf("Fluid").forGetter(FluidData::getFluid), (App)Codec.BOOL.optionalFieldOf("Tooltip", (Object)true).forGetter(d -> d.showTooltip)).apply((Applicative)builder, FluidData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidData> STREAM_CODEC = StreamCodec.of((b, d) -> {
        FluidStack.OPTIONAL_STREAM_CODEC.encode(b, (Object)d.fluid);
        b.writeBoolean(d.showTooltip);
    }, b -> new FluidData((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode(b), b.readBoolean()));
    public static final FluidData EMPTY = new FluidData(FluidStack.EMPTY, true, true);
    private final FluidStack fluid;
    public final boolean showTooltip;

    public FluidStack getFluid() {
        return this.fluid.copy();
    }

    public FluidData(@Nonnull FluidStack fluid) {
        this.fluid = fluid.copy();
        this.showTooltip = true;
    }

    public FluidData(@Nonnull FluidStack fluid, boolean showTooltip) {
        this.fluid = fluid.copy();
        this.showTooltip = showTooltip;
    }

    private FluidData(@Nonnull FluidStack fluid, boolean showTooltip, boolean ignored) {
        this.fluid = fluid;
        this.showTooltip = showTooltip;
    }

    @Nonnull
    public FluidData withFluid(@Nonnull FluidStack fluid) {
        return new FluidData(fluid, this.showTooltip);
    }

    public FluidData withTooltipVisibility(boolean showTooltip) {
        return new FluidData(this.fluid, showTooltip, false);
    }

    public int hashCode() {
        return Objects.hash(this.fluid, this.showTooltip);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FluidData) {
            FluidData other = (FluidData)obj;
            return FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)other.fluid) && this.fluid.getAmount() == other.fluid.getAmount() && this.showTooltip == other.showTooltip;
        }
        return false;
    }
}

