/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.slots;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class FluidInputSlot
extends Slot {
    public static final ResourceLocation EMPTY_FLUID_SLOT = ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"item/empty_fluid_slot");
    public static final Pair<ResourceLocation, ResourceLocation> BACKGROUND = Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_FLUID_SLOT);

    public FluidInputSlot(Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
    }

    public boolean mayPlace(ItemStack stack) {
        return stack.getItem() instanceof BucketItem || FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return BACKGROUND;
    }
}

