/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid.tradedata;

import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.client.FluidTradeButtonRenderer;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.ProductComparisonResult;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class FluidTradeData
extends TradeData {
    FluidStack product = FluidStack.EMPTY;
    int bucketQuantity = 1;
    TradeDirection tradeDirection = TradeDirection.SALE;

    public FluidStack getProduct() {
        return this.product.copy();
    }

    public void setProduct(FluidStack newProduct) {
        this.product = newProduct.copy();
        if (this.product.getFluid() != Fluids.EMPTY) {
            this.product.setAmount(1000);
        }
    }

    public FluidStack productOfQuantity() {
        FluidStack stack = this.product.copy();
        if (!stack.isEmpty()) {
            stack.setAmount(this.getQuantity());
        }
        return stack;
    }

    public int getQuantity() {
        return this.bucketQuantity * 1000;
    }

    public int getBucketQuantity() {
        return this.bucketQuantity;
    }

    public void setBucketQuantity(int value) {
        this.bucketQuantity = MathUtil.clamp((int)value, (int)1, (int)this.getMaxBucketQuantity());
    }

    public int getMaxBucketQuantity() {
        return Math.max(1, (Integer)TechConfig.SERVER.fluidTradeMaxQuantity.get());
    }

    public TradeDirection getTradeDirection() {
        return this.tradeDirection;
    }

    public void setTradeDirection(TradeDirection type) {
        if (type == TradeDirection.SALE || type == TradeDirection.PURCHASE) {
            this.tradeDirection = type;
        }
    }

    public boolean isSale() {
        return this.tradeDirection == TradeDirection.SALE;
    }

    public boolean isPurchase() {
        return this.tradeDirection == TradeDirection.PURCHASE;
    }

    public ItemStack getFilledBucket() {
        return FluidItemUtil.getFluidDispayItem(this.product.getFluid());
    }

    public FluidTradeData(boolean validateRules) {
        super(validateRules);
    }

    public boolean hasStock(FluidTraderData trader) {
        return this.getStock(trader) > 0;
    }

    public boolean hasStock(@Nonnull TradeContext context) {
        return this.getStock(context) > 0;
    }

    public int getStock(FluidTraderData trader) {
        if (this.product.isEmpty()) {
            return 0;
        }
        if (this.isSale()) {
            return trader.getStorage().getAvailableFluidCount(this.product) / this.getQuantity();
        }
        if (this.isPurchase()) {
            return this.stockCountOfCost((TraderData)trader);
        }
        return 0;
    }

    public int getStock(@Nonnull TradeContext context) {
        TraderData traderData;
        if (this.product.isEmpty()) {
            return 0;
        }
        if (!context.hasTrader() || !((traderData = context.getTrader()) instanceof FluidTraderData)) {
            return 0;
        }
        FluidTraderData trader = (FluidTraderData)traderData;
        if (trader.isCreative()) {
            return 1;
        }
        if (this.isSale()) {
            return trader.getStorage().getAvailableFluidCount(this.product) / this.getQuantity();
        }
        if (this.isPurchase()) {
            return this.stockCountOfCost(context);
        }
        return 0;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isSale()) {
            return context.hasFunds(this.getCost(context));
        }
        if (this.isPurchase()) {
            return context.hasFluid(this.productOfQuantity());
        }
        return false;
    }

    public boolean hasSpace(FluidTraderData trader) {
        if (this.isPurchase()) {
            return trader.getStorage().getFillableAmount(this.product) >= this.getQuantity();
        }
        return true;
    }

    public boolean isValid() {
        return super.isValid() && !this.product.isEmpty();
    }

    public CompoundTag getAsNBT(@Nonnull HolderLookup.Provider lookup) {
        CompoundTag compound = super.getAsNBT(lookup);
        compound.put("Trade", this.product.saveOptional(lookup));
        compound.putInt("Quantity", this.bucketQuantity);
        compound.putString("TradeType", this.tradeDirection.name());
        return compound;
    }

    public void loadFromNBT(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.loadFromNBT(compound, lookup);
        this.product = FluidStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)compound.getCompound("Trade"));
        if (compound.contains("Quantity", 3)) {
            this.bucketQuantity = compound.getInt("Quantity");
        }
        this.tradeDirection = FluidTradeData.loadTradeType(compound.getString("TradeType"));
    }

    public static TradeDirection loadTradeType(String name) {
        try {
            return TradeDirection.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            LCTech.LOGGER.error("Could not load '{}' as a TradeType.", (Object)name);
            return TradeDirection.SALE;
        }
    }

    public static List<FluidTradeData> listOfSize(int tradeCount, boolean validateRules) {
        ArrayList<FluidTradeData> list = new ArrayList<FluidTradeData>();
        while (list.size() < tradeCount) {
            list.add(new FluidTradeData(validateRules));
        }
        return list;
    }

    public static void WriteNBTList(List<FluidTradeData> tradeList, CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        FluidTradeData.WriteNBTList(tradeList, compound, "Trades", lookup);
    }

    public static void WriteNBTList(List<FluidTradeData> tradeList, CompoundTag compound, String tag, @Nonnull HolderLookup.Provider lookup) {
        ListTag list = new ListTag();
        for (FluidTradeData fluidTradeData : tradeList) {
            list.add((Object)fluidTradeData.getAsNBT(lookup));
        }
        compound.put(tag, (Tag)list);
    }

    public static List<FluidTradeData> LoadNBTList(CompoundTag compound, boolean validateRules, @Nonnull HolderLookup.Provider lookup) {
        return FluidTradeData.LoadNBTList(compound, "Trades", validateRules, lookup);
    }

    public static List<FluidTradeData> LoadNBTList(CompoundTag compound, String tag, boolean validateRules, @Nonnull HolderLookup.Provider lookup) {
        if (!compound.contains(tag)) {
            return FluidTradeData.listOfSize(1, validateRules);
        }
        ListTag list = compound.getList(tag, 10);
        ArrayList<FluidTradeData> tradeData = new ArrayList<FluidTradeData>();
        for (int i = 0; i < list.size(); ++i) {
            tradeData.add(FluidTradeData.loadData(list.getCompound(i), validateRules, lookup));
        }
        return tradeData;
    }

    public static FluidTradeData loadData(CompoundTag compound, boolean validateRules, @Nonnull HolderLookup.Provider lookup) {
        FluidTradeData trade = new FluidTradeData(validateRules);
        trade.loadFromNBT(compound, lookup);
        return trade;
    }

    public TradeComparisonResult compare(TradeData otherTrade) {
        TradeComparisonResult result = new TradeComparisonResult();
        if (otherTrade instanceof FluidTradeData) {
            FluidTradeData otherFluidTrade = (FluidTradeData)otherTrade;
            result.setCompatible();
            result.addProductResult(ProductComparisonResult.CompareFluid((FluidStack)this.productOfQuantity(), (FluidStack)otherFluidTrade.productOfQuantity()));
            result.comparePrices(this.getCost(), otherTrade.getCost());
            result.setTypeResult(this.tradeDirection == otherFluidTrade.tradeDirection);
        }
        return result;
    }

    public boolean AcceptableDifferences(TradeComparisonResult result) {
        if (!result.TypeMatches() || !result.isCompatible()) {
            return false;
        }
        if (result.getProductResultCount() <= 0) {
            return false;
        }
        ProductComparisonResult productResult = result.getProductResult(0);
        if (productResult.SameProductType() && productResult.SameProductNBT()) {
            if (this.isSale() ? productResult.ProductQuantityDifference() < 0 : this.isPurchase() && productResult.ProductQuantityDifference() > 0) {
                return false;
            }
        } else {
            return false;
        }
        if (this.isSale() && result.isPriceExpensive()) {
            return false;
        }
        return !this.isPurchase() || !result.isPriceCheaper();
    }

    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!differences.PriceMatches()) {
            ChatFormatting lessColor;
            MoneyValue difference = differences.priceDifference();
            ChatFormatting moreColor = this.isSale() ? ChatFormatting.RED : ChatFormatting.GOLD;
            ChatFormatting chatFormatting = lessColor = this.isSale() ? ChatFormatting.GOLD : ChatFormatting.RED;
            if (differences.isPriceExpensive()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_EXPENSIVE.get(new Object[]{difference.getText()}).withStyle(moreColor));
            } else {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_CHEAPER.get(new Object[]{difference.getText()}).withStyle(lessColor));
            }
        }
        if (differences.getProductResultCount() > 0) {
            MutableComponent directionName = this.isSale() ? TechText.GUI_TRADE_DIFFERENCE_PRODUCT_SALE.get(new Object[0]) : TechText.GUI_TRADE_DIFFERENCE_PRODUCT_PURCHASE.get(new Object[0]);
            ProductComparisonResult productCheck = differences.getProductResult(0);
            if (!productCheck.SameProductType()) {
                list.add((Component)TechText.GUI_TRADE_DIFFERENCE_FLUID_TYPE.get(new Object[]{directionName}).withStyle(ChatFormatting.RED));
            } else if (!productCheck.SameProductNBT()) {
                list.add((Component)TechText.GUI_TRADE_DIFFERENCE_FLUID_NBT.getWithStyle(new ChatFormatting[]{ChatFormatting.RED}));
            } else if (!productCheck.SameProductQuantity()) {
                ChatFormatting lessColor;
                int quantityDifference = productCheck.ProductQuantityDifference();
                ChatFormatting moreColor = this.isPurchase() ? ChatFormatting.RED : ChatFormatting.GOLD;
                ChatFormatting chatFormatting = lessColor = this.isSale() ? ChatFormatting.RED : ChatFormatting.GOLD;
                if (quantityDifference > 0) {
                    list.add((Component)TechText.GUI_TRADE_DIFFERENCE_FLUID_MORE.get(new Object[]{directionName, FluidFormatUtil.formatFluidAmount(quantityDifference)}).withStyle(moreColor));
                } else {
                    list.add((Component)TechText.GUI_TRADE_DIFFERENCE_FLUID_LESS.get(new Object[]{directionName, FluidFormatUtil.formatFluidAmount(-quantityDifference)}).withStyle(lessColor));
                }
            }
        }
        return list;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new FluidTradeButtonRenderer(this);
    }

    public void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            int tradeIndex = trader.getTradeData().indexOf((Object)this);
            if (tradeIndex < 0) {
                return;
            }
            if (this.isSale()) {
                tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", -1));
            }
            if (this.isPurchase() && this.onProductInteraction(tab, tradeIndex, trader, data, heldItem)) {
                tab.SendInputInteractionMessage(tradeIndex, index, data, heldItem);
            }
        }
    }

    public void OnOutputDisplayInteraction(BasicTradeEditTab tab, int index, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        TraderData traderData = ((ITraderStorageMenu)tab.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            int tradeIndex = trader.getTradeData().indexOf((Object)this);
            if (tradeIndex < 0) {
                return;
            }
            if (this.isSale()) {
                if (this.onProductInteraction(tab, tradeIndex, trader, data, heldItem)) {
                    tab.SendOutputInteractionMessage(tradeIndex, index, data, heldItem);
                }
            } else if (this.isPurchase()) {
                tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", -1));
            }
        }
    }

    private boolean onProductInteraction(@Nonnull BasicTradeEditTab tab, int tradeIndex, @Nonnull FluidTraderData trader, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        if (data.shiftHeld() || heldItem.isEmpty() && this.product.isEmpty()) {
            tab.sendOpenTabMessage(2, tab.builder().setInt("TradeIndex", tradeIndex).setInt("StartingSlot", 0));
            return false;
        }
        FluidStack heldFluid = FluidUtil.getFluidContained((ItemStack)heldItem).orElse(FluidStack.EMPTY);
        if (!heldFluid.isEmpty()) {
            this.setProduct(heldFluid);
            trader.markTradesDirty();
            if (trader.getStorage().refactorTanks()) {
                trader.markStorageDirty();
            }
            LCTech.LOGGER.debug("Set Fluid from held stack on the {}", (Object)DebugUtil.getSideText((boolean)((ITraderStorageMenu)tab.menu).isClient()));
        } else if (!this.product.isEmpty()) {
            this.setProduct(FluidStack.EMPTY);
            trader.markTradesDirty();
            if (trader.getStorage().refactorTanks()) {
                trader.markStorageDirty();
            }
            LCTech.LOGGER.debug("Cleared Fluid on the {}", (Object)DebugUtil.getSideText((boolean)((ITraderStorageMenu)tab.menu).isClient()));
        } else {
            LCTech.LOGGER.debug("Doing nothing as both the held Fluid and the current Product are empty on the {}", (Object)DebugUtil.getSideText((boolean)((ITraderStorageMenu)tab.menu).isClient()));
        }
        return ((ITraderStorageMenu)tab.menu).isClient();
    }

    public void OnInteraction(@Nonnull BasicTradeEditTab tab, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
    }
}

