/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.lightman314.lctech.common.items.FluidShardItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidItemUtil {
    public static void addFluidToRelevanceList(@Nonnull List<FluidStack> list, @Nonnull FluidStack fluid) {
        if (list.stream().anyMatch(f -> FluidStack.isSameFluidSameComponents((FluidStack)f, (FluidStack)fluid))) {
            return;
        }
        list.add(fluid);
    }

    public static void addFluidsToRelevanceList(@Nonnull List<FluidStack> list, @Nonnull List<FluidStack> fluids) {
        for (FluidStack f : fluids) {
            FluidItemUtil.addFluidToRelevanceList(list, f);
        }
    }

    public static ItemStack getFluidDisplayItem(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == Fluids.EMPTY) {
            return new ItemStack((ItemLike)Items.BUCKET);
        }
        ItemStack fluidItem = fluid.getFluidType().getBucket(fluidStack);
        if (!fluidItem.isEmpty()) {
            return fluidItem;
        }
        FluidStack tempStack = fluidStack.copy();
        tempStack.setAmount(1000);
        return FluidShardItem.GetFluidShard(tempStack);
    }

    public static ItemStack getFluidDispayItem(Fluid fluid) {
        return FluidItemUtil.getFluidDisplayItem(new FluidStack(fluid, 1000));
    }

    public static JsonElement convertFluidStack(@Nonnull FluidStack fluid, @Nonnull HolderLookup.Provider lookup) {
        return (JsonElement)FluidStack.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookup), (Object)fluid).getOrThrow();
    }

    public static FluidStack parseFluidStack(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        return (FluidStack)((Pair)FluidStack.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookup), (Object)json).getOrThrow(JsonSyntaxException::new)).getFirst();
    }
}

