/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.util.icons;

import com.google.gson.JsonObject;
import io.github.lightman314.lctech.client.util.FluidRenderUtil;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"fluid"), FluidIcon::loadFluid, FluidIcon::parseFluid);
    private final FluidStack fluid;

    public static void register() {
        IconData.registerIconType((IconData.Type)TYPE);
    }

    private FluidIcon(FluidStack fluid) {
        super(TYPE);
        this.fluid = fluid;
    }

    public static FluidIcon ofFluid(FluidStack fluid) {
        return new FluidIcon(fluid);
    }

    public void render(EasyGuiGraphics gui, int x, int y) {
        FluidRenderUtil.drawFluidTankInGUI(this.fluid, gui, x, y, 16, 16, 1.0f);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.put("Fluid", this.fluid.saveOptional(lookup));
    }

    protected void writeAdditional(JsonObject json, HolderLookup.Provider provider) {
        json.add("Fluid", FluidItemUtil.convertFluidStack(this.fluid, provider));
    }

    public boolean matches(FluidIcon other) {
        return FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)other.fluid);
    }

    private static IconData loadFluid(CompoundTag tag, HolderLookup.Provider lookup) {
        FluidStack fluid = FluidStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)tag.getCompound("Fluid"));
        return new FluidIcon(fluid);
    }

    private static IconData parseFluid(JsonObject json, HolderLookup.Provider lookup) {
        FluidStack fluid = FluidItemUtil.parseFluidStack(GsonHelper.getAsJsonObject((JsonObject)json, (String)"Fluid"), lookup);
        return new FluidIcon(fluid);
    }
}

