/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.network.message.fluid_tank;

import io.github.lightman314.lctech.common.blockentities.fluid_tank.FluidTankBlockEntity;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CMessageRequestTankStackSync
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CMessageRequestTankStackSync> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"c_tank_stack_sync_request"));
    public static final CustomPacket.Handler<CMessageRequestTankStackSync> HANDLER = new H();
    private final BlockPos tankPos;

    public CMessageRequestTankStackSync(BlockPos tankPos) {
        super(TYPE);
        this.tankPos = tankPos;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CMessageRequestTankStackSync message) {
        buffer.writeBlockPos(message.tankPos);
    }

    private static CMessageRequestTankStackSync decode(@Nonnull FriendlyByteBuf buffer) {
        return new CMessageRequestTankStackSync(buffer.readBlockPos());
    }

    private static final class H
    extends CustomPacket.Handler<CMessageRequestTankStackSync> {
        private H() {
            super(TYPE, CustomPacket.easyCodec(CMessageRequestTankStackSync::encode, CMessageRequestTankStackSync::decode));
        }

        protected void handle(@Nonnull CMessageRequestTankStackSync message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            BlockEntity blockEntity = player.level().getBlockEntity(message.tankPos);
            if (blockEntity instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tank = (FluidTankBlockEntity)blockEntity;
                tank.sendTankStackPacket(player);
            }
        }
    }
}

