/*
 * Decompiled with CFR 0.152.
 */
package dev.faststats.core.chart;

import com.google.gson.JsonElement;
import dev.faststats.core.chart.ChartId;
import dev.faststats.core.chart.SimpleBarChart;
import dev.faststats.core.chart.SingleValueChart;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public interface Chart<T> {
    @ChartId
    @Contract(pure=true)
    public String getId();

    @Contract(pure=true)
    public Optional<T> compute() throws Exception;

    @Contract(pure=true)
    public Optional<JsonElement> getData() throws Exception;

    @Deprecated
    @Contract(value="_, _ -> new", pure=true)
    public static Chart<Map<String, Number>> bar(@ChartId String id, Callable<@Nullable Map<String, Number>> callable) throws IllegalArgumentException {
        return new SimpleBarChart(id, callable);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Chart<Boolean> bool(@ChartId String id, Callable<@Nullable Boolean> callable) throws IllegalArgumentException {
        return new SingleValueChart<Boolean>(id, callable);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Chart<String> string(@ChartId String id, Callable<@Nullable String> callable) throws IllegalArgumentException {
        return new SingleValueChart<String>(id, callable);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Chart<Number> number(@ChartId String id, Callable<@Nullable Number> callable) throws IllegalArgumentException {
        return new SingleValueChart<Number>(id, callable);
    }
}

