/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.commander.paper;

import java.util.stream.Stream;
import net.thenextlvl.binder.StaticBinder;
import net.thenextlvl.commander.CommandFinder;
import net.thenextlvl.commander.CommandRegistry;
import net.thenextlvl.commander.CommanderCommons;
import net.thenextlvl.commander.PermissionOverride;
import net.thenextlvl.commander.access.BrigadierAccess;
import net.thenextlvl.commander.paper.CommanderPlugin;
import net.thenextlvl.commander.paper.access.PaperBrigadierAccess;
import net.thenextlvl.commander.paper.implementation.PaperCommandFinder;
import net.thenextlvl.commander.paper.implementation.PaperCommandRegistry;
import net.thenextlvl.commander.paper.implementation.PaperPermissionOverride;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;

@NullMarked
public class PaperCommander
extends CommanderCommons {
    private final PaperBrigadierAccess brigadierAccess = new PaperBrigadierAccess();
    private final PaperCommandFinder commandFinder;
    private final PaperCommandRegistry commandRegistry;
    private final PaperPermissionOverride permissionOverride;
    private final CommanderPlugin plugin;

    public PaperCommander(CommanderPlugin plugin) {
        super(plugin.getDataPath());
        this.plugin = plugin;
        this.commandFinder = new PaperCommandFinder(this);
        this.commandRegistry = new PaperCommandRegistry(this);
        this.permissionOverride = new PaperPermissionOverride(this);
        StaticBinder.getInstance(CommandFinder.class.getClassLoader()).bind(CommandFinder.class, this.commandFinder);
        StaticBinder.getInstance(CommandRegistry.class.getClassLoader()).bind(CommandRegistry.class, this.commandRegistry);
        StaticBinder.getInstance(PermissionOverride.class.getClassLoader()).bind(PermissionOverride.class, this.permissionOverride);
    }

    public CommanderPlugin getPlugin() {
        return this.plugin;
    }

    public Server getServer() {
        return this.plugin.getServer();
    }

    @Override
    public Logger logger() {
        return this.plugin.getSLF4JLogger();
    }

    @Override
    public <S> BrigadierAccess<S> brigadierAccess() {
        return this.brigadierAccess;
    }

    @Override
    public String getRootCommand() {
        return "command";
    }

    @Override
    public Stream<String> getKnownCommands() {
        return this.plugin.getServer().getCommandMap().getKnownCommands().values().stream().map(Command::getLabel);
    }

    @Override
    public Stream<String> getKnownPermissions() {
        return this.plugin.getServer().getPluginManager().getPermissions().stream().map(Permission::getName);
    }

    @Override
    public void updateCommands() {
        this.plugin.getServer().getOnlinePlayers().forEach(Player::updateCommands);
    }

    @Override
    public PaperCommandFinder commandFinder() {
        return this.commandFinder;
    }

    @Override
    public PaperCommandRegistry commandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public PaperPermissionOverride permissionOverride() {
        return this.permissionOverride;
    }
}

