/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.network.message;

import insane96mcp.insanelib.network.NetworkHandler;
import insane96mcp.insanelib.util.ModNBTData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class EntityModNBTDataSync<T> {
    final int entityId;
    final ResourceLocation path;
    final int type;
    final T value;

    public EntityModNBTDataSync(int entityId, ResourceLocation path, int type, T value) {
        this.entityId = entityId;
        this.path = path;
        this.type = type;
        this.value = value;
    }

    public static <T> void encode(EntityModNBTDataSync<T> pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.entityId);
        buf.m_130085_(pkt.path);
        buf.writeInt(pkt.type);
        switch (pkt.type) {
            case 1: {
                buf.writeByte((int)((Byte)pkt.value).byteValue());
                break;
            }
            case 2: {
                buf.writeShort((int)((Short)pkt.value).shortValue());
                break;
            }
            case 3: {
                buf.writeInt(((Integer)pkt.value).intValue());
                break;
            }
            case 4: {
                buf.writeLong(((Long)pkt.value).longValue());
                break;
            }
            case 5: {
                buf.writeFloat(((Float)pkt.value).floatValue());
                break;
            }
            case 6: {
                buf.writeDouble(((Double)pkt.value).doubleValue());
                break;
            }
            case 7: {
                buf.m_130087_((byte[])pkt.value);
                break;
            }
            case 8: {
                buf.m_130070_((String)pkt.value);
                break;
            }
            case 10: {
                buf.m_130079_((CompoundTag)pkt.value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tag type for sync: " + pkt.type);
            }
        }
    }

    public static EntityModNBTDataSync<?> decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        ResourceLocation path = buf.m_130281_();
        int type = buf.readInt();
        return new EntityModNBTDataSync<byte[]>(entityId, path, type, (byte[])(switch (type) {
            case 1 -> (Object)buf.readByte();
            case 2 -> (Object)buf.readShort();
            case 3 -> (Object)buf.readInt();
            case 4 -> (Object)buf.readLong();
            case 5 -> (Object)Float.valueOf(buf.readFloat());
            case 6 -> (Object)buf.readDouble();
            case 7 -> buf.m_130052_();
            case 8 -> (Object)buf.m_130277_();
            case 10 -> (Object)buf.m_130260_();
            default -> throw new IllegalArgumentException("Unsupported tag type for sync: " + type);
        }));
    }

    public static void handle(EntityModNBTDataSync<?> message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            ModNBTData.put((Entity)livingEntity, message.path, message.value);
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sync(LivingEntity entity, ResourceLocation path, Class<?> type) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_6907_().forEach(player -> EntityModNBTDataSync.sync(player, entity, path, type));
    }

    public static <T> void sync(ServerPlayer player, LivingEntity entity, ResourceLocation path, Class<T> type) {
        T value = ModNBTData.get((Entity)entity, path, type);
        EntityModNBTDataSync<T> msg = new EntityModNBTDataSync<T>(entity.m_19879_(), path, ModNBTData.classToNBTType(type), value);
        NetworkHandler.CHANNEL.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

