/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.util;

import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ModNBTData {
    public static CompoundTag getPersistedModData(Player player, String modId) {
        return ModNBTData.getModData(MCUtils.getOrCreatePersistedData(player), modId);
    }

    public static CompoundTag getModData(Entity entity, String modId) {
        return ModNBTData.getModData(entity.getPersistentData(), modId);
    }

    public static CompoundTag getModData(ItemStack stack, String modId) {
        return ModNBTData.getModData(stack.m_41784_(), modId);
    }

    public static CompoundTag getModData(CompoundTag compound, String modId) {
        if (compound.m_128441_(modId)) {
            return compound.m_128469_(modId);
        }
        CompoundTag tag = new CompoundTag();
        compound.m_128365_(modId, (Tag)tag);
        return tag;
    }

    public static <T> T get(Entity entity, ResourceLocation loc, Class<T> type) {
        return ModNBTData.get(entity.getPersistentData(), loc, type);
    }

    public static <T> T getPersisted(Player player, ResourceLocation loc, Class<T> type) {
        return ModNBTData.get(MCUtils.getOrCreatePersistedData(player), loc, type);
    }

    public static <T> T get(ItemStack stack, ResourceLocation loc, Class<T> type) {
        if (stack.m_41783_() == null) {
            return null;
        }
        return ModNBTData.get(stack.m_41783_(), loc, type);
    }

    public static <T> T get(CompoundTag tag, ResourceLocation loc, Class<T> type) {
        CompoundTag modData = ModNBTData.getNestedCompounds(loc.m_135815_(), ModNBTData.getModData(tag, loc.m_135827_()));
        String key = ModNBTData.getNestedKey(loc.m_135815_());
        if (type == Byte.class) {
            return type.cast(modData.m_128445_(key));
        }
        if (type == Short.class) {
            return type.cast(modData.m_128448_(key));
        }
        if (type == Integer.class) {
            return type.cast(modData.m_128451_(key));
        }
        if (type == Long.class) {
            return type.cast(modData.m_128454_(key));
        }
        if (type == Float.class) {
            return type.cast(Float.valueOf(modData.m_128457_(key)));
        }
        if (type == Double.class) {
            return type.cast(modData.m_128459_(key));
        }
        if (type == Boolean.class) {
            return type.cast(modData.m_128471_(key));
        }
        if (type == String.class) {
            return type.cast(modData.m_128461_(key));
        }
        if (type == UUID.class) {
            return type.cast(modData.m_128342_(key));
        }
        if (type == CompoundTag.class) {
            return type.cast(modData.m_128469_(key));
        }
        if (type == int[].class) {
            return type.cast(modData.m_128465_(key));
        }
        if (type == ListTag.class) {
            throw new IllegalArgumentException("Use getList overload");
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    public static void put(Entity entity, ResourceLocation loc, Object value) {
        ModNBTData.put(entity.getPersistentData(), loc, value);
    }

    public static void putPersisted(Player player, ResourceLocation loc, Object value) {
        ModNBTData.put(MCUtils.getOrCreatePersistedData(player), loc, value);
    }

    public static void put(ItemStack stack, ResourceLocation loc, Object value) {
        ModNBTData.put(stack.m_41784_(), loc, value);
    }

    public static void put(CompoundTag tag, ResourceLocation loc, Object value) {
        CompoundTag modData = ModNBTData.getNestedCompounds(loc.m_135815_(), ModNBTData.getModData(tag, loc.m_135827_()));
        String key = ModNBTData.getNestedKey(loc.m_135815_());
        if (value instanceof Byte) {
            Byte b = (Byte)value;
            modData.m_128344_(key, b.byteValue());
        } else if (value instanceof Short) {
            Short s = (Short)value;
            modData.m_128376_(key, s.shortValue());
        } else if (value instanceof Integer) {
            Integer i = (Integer)value;
            modData.m_128405_(key, i.intValue());
        } else if (value instanceof Long) {
            Long l = (Long)value;
            modData.m_128356_(key, l.longValue());
        } else if (value instanceof Float) {
            Float f = (Float)value;
            modData.m_128350_(key, f.floatValue());
        } else if (value instanceof Double) {
            Double d = (Double)value;
            modData.m_128347_(key, d.doubleValue());
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            modData.m_128379_(key, bool.booleanValue());
        } else if (value instanceof String) {
            String str = (String)value;
            modData.m_128359_(key, str);
        } else if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            modData.m_128362_(key, uuid);
        } else if (value instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)value;
            modData.m_128365_(key, (Tag)compound);
        } else if (value instanceof int[]) {
            int[] intArray = (int[])value;
            modData.m_128365_(key, (Tag)new IntArrayTag(intArray));
        } else if (value instanceof ListTag) {
            ListTag list = (ListTag)value;
            modData.m_128365_(key, (Tag)list);
        } else {
            throw new IllegalArgumentException("Unsupported value type: " + String.valueOf(value.getClass()));
        }
    }

    private static String getNestedKey(String path) {
        String key = path;
        if (key.contains("/")) {
            String[] parts = path.split("/");
            key = parts[parts.length - 1];
        }
        return key;
    }

    private static CompoundTag getNestedCompounds(String path, CompoundTag modData) {
        if (path.contains("/")) {
            String[] parts = path.split("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                modData = ModNBTData.getModData(modData, parts[i]);
            }
        }
        return modData;
    }

    public static ListTag getList(Entity entity, ResourceLocation loc, int type) {
        return ModNBTData.getList(entity.getPersistentData(), loc, type);
    }

    public static ListTag getListPersisted(Player player, ResourceLocation loc, int type) {
        return ModNBTData.getList(MCUtils.getOrCreatePersistedData(player), loc, type);
    }

    public static ListTag getList(ItemStack stack, ResourceLocation loc, int type) {
        return ModNBTData.getList(stack.m_41784_(), loc, type);
    }

    public static ListTag getList(CompoundTag tag, ResourceLocation loc, int type) {
        CompoundTag modData = ModNBTData.getNestedCompounds(loc.m_135815_(), ModNBTData.getModData(tag, loc.m_135827_()));
        String key = ModNBTData.getNestedKey(loc.m_135815_());
        return modData.m_128437_(key, type);
    }

    public static boolean contains(Entity entity, ResourceLocation loc) {
        return ModNBTData.contains(entity.getPersistentData(), loc);
    }

    public static boolean contains(Player player, ResourceLocation loc) {
        return ModNBTData.contains(MCUtils.getOrCreatePersistedData(player), loc);
    }

    public static boolean contains(ItemStack stack, ResourceLocation loc) {
        if (stack.m_41783_() == null) {
            return false;
        }
        return ModNBTData.contains(stack.m_41783_(), loc);
    }

    public static boolean contains(CompoundTag tag, ResourceLocation loc) {
        CompoundTag modData = ModNBTData.getNestedCompounds(loc.m_135815_(), ModNBTData.getModData(tag, loc.m_135827_()));
        String key = ModNBTData.getNestedKey(loc.m_135815_());
        return modData.m_128441_(key);
    }

    public static void remove(Entity entity, ResourceLocation loc) {
        ModNBTData.remove(entity.getPersistentData(), loc);
    }

    public static void removePersisted(Player player, ResourceLocation loc) {
        ModNBTData.remove(player.getPersistentData(), loc);
    }

    public static void remove(ItemStack stack, ResourceLocation loc) {
        if (stack.m_41783_() == null) {
            return;
        }
        ModNBTData.remove(stack.m_41783_(), loc);
    }

    public static void remove(CompoundTag tag, ResourceLocation loc) {
        CompoundTag modData = ModNBTData.getNestedCompounds(loc.m_135815_(), ModNBTData.getModData(tag, loc.m_135827_()));
        String key = ModNBTData.getNestedKey(loc.m_135815_());
        modData.m_128473_(key);
    }

    public static int classToNBTType(Class<?> type) {
        if (type == Byte.class || type == Boolean.class) {
            return 1;
        }
        if (type == Short.class) {
            return 2;
        }
        if (type == Integer.class) {
            return 3;
        }
        if (type == Long.class) {
            return 4;
        }
        if (type == Float.class) {
            return 5;
        }
        if (type == Double.class) {
            return 6;
        }
        if (type == byte[].class || type == Byte[].class) {
            return 7;
        }
        if (type == String.class) {
            return 8;
        }
        if (type == ListTag.class) {
            return 9;
        }
        if (type == CompoundTag.class) {
            return 10;
        }
        if (type == UUID.class || type == int[].class || type == Integer[].class) {
            return 11;
        }
        if (type == long[].class || type == Long[].class) {
            return 12;
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    public static Class<?> nbtTypeToClass(int type) {
        if (type == 1) {
            return Byte.class;
        }
        if (type == 2) {
            return Short.class;
        }
        if (type == 3) {
            return Integer.class;
        }
        if (type == 4) {
            return Long.class;
        }
        if (type == 5) {
            return Float.class;
        }
        if (type == 6) {
            return Double.class;
        }
        if (type == 7) {
            return byte[].class;
        }
        if (type == 8) {
            return String.class;
        }
        if (type == 9) {
            return ListTag.class;
        }
        if (type == 10) {
            return CompoundTag.class;
        }
        if (type == 11) {
            return int[].class;
        }
        if (type == 12) {
            return long[].class;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }
}

