/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import insane96mcp.insanelib.InsaneLib;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Module;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class FeatureEnabledCondition
implements ICondition {
    private static final ResourceLocation ID = InsaneLib.location("feature_enabled");
    private final String featureName;

    public FeatureEnabledCondition(String featureName) {
        this.featureName = featureName;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        return Feature.isEnabled(this.featureName);
    }

    public String toString() {
        return "feature_enabled(\"" + this.featureName + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<FeatureEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, FeatureEnabledCondition value) {
            json.addProperty("feature", value.featureName);
        }

        public FeatureEnabledCondition read(JsonObject json) {
            String feature = GsonHelper.m_13906_((JsonObject)json, (String)"feature");
            if (Module.getFeature(feature).isEmpty()) {
                throw new JsonSyntaxException("Unknown feature: " + feature);
            }
            return new FeatureEnabledCondition(feature);
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

