/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.info;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.function.Supplier;
import ru.kelcuprum.alinlib.AlinLib;

public class World {
    public static HashMap<String, Supplier<String>> worldsName = new HashMap();

    public static String getTimeType() {
        if (AlinLib.MINECRAFT.field_1687 == null) {
            return "";
        }
        long currentTime = World.getDayTime();
        if (currentTime < 6000L && currentTime > 0L) {
            return AlinLib.localization.getLocalization("time.morning", false, false);
        }
        if (currentTime < 12000L && currentTime > 6000L) {
            return AlinLib.localization.getLocalization("time.day", false, false);
        }
        if (currentTime < 16500L && currentTime > 12000L) {
            return AlinLib.localization.getLocalization("time.evening", false, false);
        }
        if (currentTime > 16500L) {
            return AlinLib.localization.getLocalization("time.night", false, false);
        }
        return "";
    }

    public static String getFormattedTime() {
        Object clock;
        if (AlinLib.MINECRAFT.field_1687 == null) {
            return "";
        }
        long daytime = World.getTime() + 6000L;
        int hours = (int)(daytime / 1000L) % 24;
        int minutes = (int)(daytime % 1000L * 60L / 1000L);
        int day = (int)daytime / 1000 / 24;
        try {
            String strDateFormat = AlinLib.localization.getLocalization("date.time", false, false);
            SimpleDateFormat dateFormat = new SimpleDateFormat(strDateFormat);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(2000, 0, day + 1, hours, minutes, 0);
            clock = dateFormat.format(calendar.getTimeInMillis());
            if (strDateFormat.contains("hh")) {
                clock = (String)clock + (hours >= 12 ? "pm" : "am");
            }
        }
        catch (IllegalArgumentException ex) {
            clock = "[It's not correct format for Java SimpleDateFormat]";
        }
        return clock;
    }

    public static long getTime() {
        return AlinLib.MINECRAFT.field_1687 == null ? -1L : AlinLib.MINECRAFT.field_1687.method_8532();
    }

    public static long getDayTime() {
        return AlinLib.MINECRAFT.field_1687 == null ? -1L : AlinLib.MINECRAFT.field_1687.method_8532() % 24000L;
    }

    public static int getDays() {
        return AlinLib.MINECRAFT.field_1687 == null ? -1 : (int)(AlinLib.MINECRAFT.field_1687.method_8532() / 24000L);
    }

    public static String getCodeName() {
        return AlinLib.MINECRAFT.field_1687 == null ? "unknown" : AlinLib.MINECRAFT.field_1687.method_27983().method_29177().toString();
    }

    public static void register(String id, String name) {
        World.register(id, () -> name);
    }

    public static void register(String id, Supplier<String> name) {
        worldsName.put(id, name);
    }

    public static void registerDefaultWorlds() {
        World.register("minecraft:the_moon", () -> AlinLib.localization.getLocalization("world.moon", false, false));
        World.register("minecraft:the_end", () -> AlinLib.localization.getLocalization("world.the_end", false, false));
        World.register("minecraft:the_nether", () -> AlinLib.localization.getLocalization("world.nether", false, false));
        World.register("minecraft:overworld", () -> AlinLib.localization.getLocalization("world.overworld", false, false));
    }

    public static String getName() {
        String world = World.getCodeName();
        return worldsName.getOrDefault(world, () -> world).get();
    }
}

