/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.gui.components.text;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.components.Description;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;

public class TextBox
extends class_339
implements Description {
    public final TextBuilder builder;
    protected class_2561 description;

    public TextBox(TextBuilder builder) {
        super(builder.getX(), builder.getY(), builder.getWidth(), builder.getHeight(), builder.getTitle());
        this.builder = builder;
        this.setActive(builder.onPress != null);
    }

    public void setActive(boolean active) {
        this.field_22763 = active;
    }

    public void method_46421(int x) {
        super.method_46421(x);
    }

    public void method_46419(int y) {
        super.method_46419(y);
    }

    public void method_48229(int x, int y) {
        super.method_48229(x, y);
    }

    public void onPress() {
        if (this.builder.getOnPress() != null) {
            this.builder.getOnPress().onPress(this);
        }
    }

    public void method_25355(class_2561 component) {
        this.builder.setTitle(component);
        super.method_25355(component);
    }

    public int method_25364() {
        if (this.builder.type == TextBuilder.TYPE.TEXT) {
            this.field_22759 = this.builder.getHeight();
            return super.method_25364();
        }
        Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
        this.field_22759 = 8 + (9 + 3) * AlinLib.MINECRAFT.field_1772.method_1728((class_5348)this.method_25369(), this.field_22758 - 12).size();
        return this.field_22759;
    }

    public void method_53533(int i) {
        this.builder.setHeight(i);
        super.method_53533(i);
    }

    public List<class_5481> getArrayTexts(int border) {
        return AlinLib.MINECRAFT.field_1772.method_1728((class_5348)this.method_25369(), this.field_22758 - border);
    }

    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        this.renderBackground(guiGraphics);
        if (this.builder.type == TextBuilder.TYPE.TEXT) {
            if (this.isDoesNotFit()) {
                this.renderScrollingString(guiGraphics, AlinLib.MINECRAFT.field_1772, 2, this.builder.getStyle().getTextColor(this.builder.type), this.builder.getStyle().textShadow(this.builder.type));
            } else if (this.builder.align == TextBuilder.ALIGN.CENTER) {
                guiGraphics.method_51439(AlinLib.MINECRAFT.field_1772, this.method_25369(), this.method_46426() + this.method_25368() / 2 - AlinLib.MINECRAFT.field_1772.method_27525((class_5348)this.method_25369()) / 2, this.method_46427() + (this.method_25364() - 8) / 2, this.builder.getStyle().getTextColor(this.builder.type), this.builder.getStyle().textShadow(this.builder.type));
            } else {
                guiGraphics.method_51439(AlinLib.MINECRAFT.field_1772, this.method_25369(), this.builder.align == TextBuilder.ALIGN.LEFT ? this.method_46426() + (this.method_25364() - 8) / 2 : this.method_46426() + this.method_25368() - (this.method_25364() - 8) / 2 - AlinLib.MINECRAFT.field_1772.method_27525((class_5348)this.method_25369()), this.method_46427() + (this.method_25364() - 8) / 2, this.builder.getStyle().getTextColor(this.builder.type), this.builder.getStyle().textShadow(this.builder.type));
            }
        } else {
            this.renderMessageText(guiGraphics);
        }
        if (this.method_49606() && this.builder.onPress != null) {
            guiGraphics.method_74037(this.method_37303() ? class_11876.field_62455 : class_11876.field_62459);
        }
    }

    public void renderBackground(class_332 guiGraphics) {
        if (this.builder.type != TextBuilder.TYPE.BLOCKQUOTE && this.builder.onPress != null) {
            this.builder.getStyle().renderBackground$widget(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), true, this.method_25367());
        } else if (this.builder.type == TextBuilder.TYPE.BLOCKQUOTE) {
            this.builder.getStyle().renderBlockquoteBackground(this.builder, guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.getBlockquoteColor());
        }
    }

    public int[] getBlockquoteColor() {
        return this.builder.color == null ? this.builder.getStyle().getBlockquoteColors() : this.builder.color;
    }

    public void renderMessageText(class_332 guiGraphics) {
        List<class_5481> list = this.getArrayTexts(this.builder.type == TextBuilder.TYPE.BLOCKQUOTE && this.builder.align != TextBuilder.ALIGN.CENTER ? 13 : 12);
        int l = 0;
        for (class_5481 text : list) {
            if (this.builder.align == TextBuilder.ALIGN.CENTER) {
                class_327 class_3272 = AlinLib.MINECRAFT.field_1772;
                int n = this.method_46426() + this.method_25368() / 2 - AlinLib.MINECRAFT.field_1772.method_30880(text) / 2;
                int n2 = this.method_46427() + 6;
                Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                guiGraphics.method_51430(class_3272, text, n, n2 + (9 + 3) * l, this.builder.getStyle().getTextColor(this.builder.type), this.builder.getStyle().textShadow(this.builder.type));
            } else {
                class_327 class_3273 = AlinLib.MINECRAFT.field_1772;
                int n = this.builder.align == TextBuilder.ALIGN.LEFT ? this.method_46426() + (this.builder.type == TextBuilder.TYPE.BLOCKQUOTE ? 7 : 6) : this.method_46426() + this.method_25368() - 6 - AlinLib.MINECRAFT.field_1772.method_30880(text);
                int n3 = this.method_46427() + 6;
                Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                guiGraphics.method_51430(class_3273, text, n, n3 + (9 + 3) * l, this.builder.getStyle().getTextColor(this.builder.type), this.builder.getStyle().textShadow(this.builder.type));
            }
            ++l;
        }
    }

    public static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 component, int i, int j, int k, int l, int m, boolean shadow) {
        TextBox.renderScrollingString(guiGraphics, font, component, (i + k) / 2, i, j, k, l, m, shadow);
    }

    public static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 component, int i, int j, int k, int l, int m, int n, boolean shadow) {
        int o = font.method_27525((class_5348)component);
        int var10000 = k + m;
        Objects.requireNonNull(font);
        int p = (var10000 - 9) / 2 + 1;
        int q = l - j;
        if (o > q) {
            int r = o - q;
            double d = (double)class_156.method_658() / 1000.0;
            double e = Math.max((double)r * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = class_3532.method_16436((double)f, (double)0.0, (double)r);
            guiGraphics.method_44379(j, k, l, m);
            guiGraphics.method_51439(font, component, j - (int)g, p, n, shadow);
            guiGraphics.method_44380();
        } else {
            int r = class_3532.method_15340((int)i, (int)(j + o / 2), (int)(l - o / 2));
            guiGraphics.method_51439(font, component, r - font.method_27525((class_5348)component) / 2, p, n, shadow);
        }
    }

    protected void renderScrollingString(class_332 guiGraphics, class_327 font, int i, int j, boolean shadow) {
        int k = this.method_46426() + i;
        int l = this.method_46426() + this.method_25368() - i;
        TextBox.renderScrollingString(guiGraphics, font, this.method_25369(), k, this.method_46427(), l, this.method_46427() + this.method_25364(), j, shadow);
    }

    private boolean isDoesNotFit() {
        int size = AlinLib.MINECRAFT.field_1772.method_27525((class_5348)this.method_25369()) + (this.method_25364() - 8) / 2 * 2;
        return size > this.method_25368();
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
        this.onPress();
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        double d = mouseButtonEvent.comp_4798();
        double e = mouseButtonEvent.comp_4799();
        if (this.builder.type == TextBuilder.TYPE.BLOCKQUOTE || this.builder.type == TextBuilder.TYPE.MESSAGE) {
            List<class_5481> list = this.getArrayTexts(this.builder.type == TextBuilder.TYPE.BLOCKQUOTE && this.builder.align != TextBuilder.ALIGN.CENTER ? 13 : 12);
            int l = 0;
            int x = this.method_46426() + (this.builder.type == TextBuilder.TYPE.BLOCKQUOTE ? 7 : 6);
            for (class_5481 chars : list) {
                int n = this.method_46427() + 6;
                Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                int y = n + (9 + 3) * l;
                if ((double)x <= d && d <= (double)(x + AlinLib.MINECRAFT.field_1772.method_30880(chars)) && (double)y <= e) {
                    class_2583 style;
                    Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                    if (e <= (double)(y + 9) && (style = AlinLib.MINECRAFT.field_1772.method_27527().method_30876(chars, class_3532.method_15357((double)this.screenToChatX(x, d)))) != null && this.handleComponentClicked(style)) {
                        return true;
                    }
                }
                ++l;
            }
            return super.method_25402(mouseButtonEvent, bl);
        }
        return super.method_25402(mouseButtonEvent, bl);
    }

    public boolean handleComponentClicked(@Nullable class_2583 style) {
        if (style == null) {
            return false;
        }
        class_2558 clickEvent = style.method_10970();
        if (clickEvent != null) {
            if (clickEvent.method_10845() == class_2558.class_2559.field_11749) {
                if (!((Boolean)AlinLib.MINECRAFT.field_1690.method_42429().method_41753()).booleanValue()) {
                    return false;
                }
                URI uRI = ((class_2558.class_10608)clickEvent).comp_3505();
                if (((Boolean)AlinLib.MINECRAFT.field_1690.method_42431().method_41753()).booleanValue()) {
                    class_437 current = AlinLib.MINECRAFT.field_1755;
                    AlinLib.MINECRAFT.method_1507((class_437)new class_407(bl -> {
                        if (bl) {
                            class_156.method_668().method_673(uRI);
                        }
                        AlinLib.MINECRAFT.method_1507(current);
                    }, uRI.toString(), false));
                } else {
                    class_156.method_668().method_673(uRI);
                }
            } else if (clickEvent.method_10845() == class_2558.class_2559.field_11746) {
                class_156.method_668().method_672(((class_2558.class_10607)clickEvent).method_66568());
            } else if (clickEvent.method_10845() == class_2558.class_2559.field_11750) {
                String string = class_3544.method_57180((String)((class_2558.class_10609)clickEvent).comp_3506());
                if (string.startsWith("/")) {
                    assert (AlinLib.MINECRAFT.field_1724 != null);
                    try {
                        AlinLib.MINECRAFT.field_1724.field_3944.method_45730(string.substring(1));
                    }
                    catch (Exception ignored) {
                        AlinLib.LOG.error("Not allowed to run command with signed argument from click event: '{}'", string);
                    }
                } else {
                    AlinLib.LOG.error("Failed to run command without '/' prefix from click event: '{}'", string);
                }
            } else if (clickEvent.method_10845() == class_2558.class_2559.field_21462) {
                AlinLib.MINECRAFT.field_1774.method_1455(((class_2558.class_10606)clickEvent).comp_3503());
            } else {
                AlinLib.LOG.error("Don't know how to handle {}", clickEvent);
            }
            return true;
        }
        return false;
    }

    private double screenToChatX(int x, double d) {
        return d - (double)x;
    }

    public boolean method_25404(class_11908 keyEvent) {
        int i = keyEvent.comp_4795();
        if (this.field_22763 && this.field_22764) {
            if (i == 257 || i == 32 || i == 335) {
                this.method_25354(AlinLib.MINECRAFT.method_1483());
                this.onPress();
                return true;
            }
            return false;
        }
        return false;
    }

    public TextBox setDescription(class_2561 description) {
        this.description = description;
        return this;
    }

    @Override
    public class_2561 getDescription() {
        return this.description;
    }

    public static interface OnPress {
        public void onPress(TextBox var1);
    }
}

