/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3518;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.alinlib.AlinLib;

public class Config {
    private String _filePath;
    private JsonObject _jsonConfiguration = new JsonObject();
    private final boolean _isFile;
    private final Map<String, Boolean> booleanDefaults = new HashMap<String, Boolean>();
    private final Map<String, String> stringDefaults = new HashMap<String, String>();
    private final Map<String, Number> numberDefaults = new HashMap<String, Number>();
    private final Map<String, JsonObject> jsonObjectDefaults = new HashMap<String, JsonObject>();
    private final Map<String, JsonArray> jsonArrayDefaults = new HashMap<String, JsonArray>();
    private boolean defaultBooleanValue = false;
    private String defaultStringValue = "";
    private Number defaultNumberValue = 0;
    private JsonObject defaultJsonObjectValue = new JsonObject();
    private JsonArray defaultJsonArrayValue = new JsonArray();
    private JsonElement defaultJsonElementValue = new JsonObject();

    public Config(String filePath) {
        this._filePath = filePath;
        this._isFile = true;
        this.load();
    }

    public Config(JsonObject jsonConfiguration) {
        this._jsonConfiguration = jsonConfiguration;
        this._isFile = false;
    }

    public Config setDefaultValue(Boolean value) {
        this.defaultBooleanValue = value;
        return this;
    }

    public Config setDefaultValue(String value) {
        this.defaultStringValue = value;
        return this;
    }

    public Config setDefaultValue(Number value) {
        this.defaultNumberValue = value;
        return this;
    }

    public Config setDefaultValue(JsonObject value) {
        this.defaultJsonObjectValue = value;
        return this;
    }

    public Config setDefaultValue(JsonArray value) {
        this.defaultJsonArrayValue = value;
        return this;
    }

    public Config setDefaultValue(JsonElement value) {
        this.defaultJsonElementValue = value;
        return this;
    }

    public Config registerValue(String key, Boolean value) {
        this.booleanDefaults.put(key, value);
        return this;
    }

    public Boolean getBoolean(String key) {
        if (this.booleanDefaults.get(key) == null) {
            return this.getBoolean(key, this.defaultBooleanValue);
        }
        return this.getBoolean(key, this.booleanDefaults.get(key));
    }

    public Config registerValue(String key, String value) {
        this.stringDefaults.put(key, value);
        return this;
    }

    public String getString(String key) {
        if (this.stringDefaults.get(key) == null) {
            return this.getString(key, this.defaultStringValue);
        }
        return this.getString(key, this.stringDefaults.get(key));
    }

    public Config registerValue(String key, Number value) {
        this.numberDefaults.put(key, value);
        return this;
    }

    public Number getNumber(String key) {
        if (this.numberDefaults.get(key) == null) {
            return this.getNumber(key, this.defaultNumberValue);
        }
        return this.getNumber(key, this.numberDefaults.get(key));
    }

    public Config registerValue(String key, JsonObject value) {
        this.jsonObjectDefaults.put(key, value);
        return this;
    }

    public JsonObject getJsonObject(String key) {
        if (this.jsonObjectDefaults.get(key) == null) {
            return this.getJsonObject(key, this.defaultJsonObjectValue);
        }
        return this.getJsonObject(key, this.jsonObjectDefaults.get(key));
    }

    public Config registerValue(String key, JsonArray value) {
        this.jsonArrayDefaults.put(key, value);
        return this;
    }

    public JsonArray getJsonArray(String key) {
        if (this.jsonArrayDefaults.get(key) == null) {
            return this.getJsonArray(key, this.defaultJsonArrayValue);
        }
        return this.getJsonArray(key, this.jsonArrayDefaults.get(key));
    }

    public JsonElement getJsonElement(String key) {
        if (this.jsonArrayDefaults.get(key) == null) {
            return this.getJsonElement(key, (JsonElement)this.defaultJsonArrayValue);
        }
        return this.getJsonElement(key, (JsonElement)this.jsonArrayDefaults.get(key));
    }

    public void save() {
        if (!this._isFile) {
            return;
        }
        Path configFile = Path.of(this._filePath, new String[0]);
        try {
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            Files.writeString(configFile, (CharSequence)this._jsonConfiguration.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            AlinLib.LOG.log(e.getLocalizedMessage(), Level.ERROR);
        }
    }

    public void load() {
        if (!this._isFile) {
            return;
        }
        Path configFile = Path.of(this._filePath, new String[0]);
        try {
            this._jsonConfiguration = configFile.toFile().exists() ? class_3518.method_15285((String)Files.readString(configFile)) : new JsonObject();
        }
        catch (Exception e) {
            AlinLib.LOG.log(e.getLocalizedMessage(), Level.ERROR);
            this.save();
        }
    }

    public Config reset() {
        this._jsonConfiguration = new JsonObject();
        this.save();
        return this;
    }

    public JsonObject toJSON() {
        return this._jsonConfiguration;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public boolean isJsonNull(String type) {
        if (this._jsonConfiguration == null) {
            this._jsonConfiguration = new JsonObject();
        }
        if (!this._jsonConfiguration.has(type)) {
            return true;
        }
        return this._jsonConfiguration.get(type).isJsonNull();
    }

    public boolean getBoolean(String type, boolean defaultValue) {
        if (this._jsonConfiguration == null) {
            this._jsonConfiguration = new JsonObject();
        }
        if (!this.isJsonNull(type) && !this._jsonConfiguration.get(type).getAsJsonPrimitive().isBoolean()) {
            this.setBoolean(type, defaultValue);
        }
        return this.isJsonNull(type) ? defaultValue : this._jsonConfiguration.get(type).getAsBoolean();
    }

    public Config setBoolean(String type, boolean newValue) {
        this._jsonConfiguration.addProperty(type, Boolean.valueOf(newValue));
        this.save();
        return this;
    }

    public String getString(String type, String defaultValue) {
        if (this._jsonConfiguration == null) {
            this._jsonConfiguration = new JsonObject();
        }
        if (!this.isJsonNull(type) && !this._jsonConfiguration.get(type).getAsJsonPrimitive().isString()) {
            this.setString(type, defaultValue);
        }
        return this.isJsonNull(type) ? defaultValue : this._jsonConfiguration.get(type).getAsString();
    }

    public Config setString(String type, String newValue) {
        this._jsonConfiguration.addProperty(type, newValue);
        this.save();
        return this;
    }

    public Number getNumber(String type, Number defaultValue) {
        if (this._jsonConfiguration == null) {
            this._jsonConfiguration = new JsonObject();
        }
        if (!this.isJsonNull(type) && !this._jsonConfiguration.get(type).getAsJsonPrimitive().isNumber()) {
            this.setNumber(type, defaultValue);
        }
        return this.isJsonNull(type) ? (Number)defaultValue : (Number)this._jsonConfiguration.get(type).getAsNumber();
    }

    public Config setNumber(String type, Number newValue) {
        this._jsonConfiguration.addProperty(type, newValue);
        this.save();
        return this;
    }

    public JsonObject getJsonObject(String type, JsonObject defaultValue) {
        if (this._jsonConfiguration == null) {
            this._jsonConfiguration = new JsonObject();
        }
        if (!this.isJsonNull(type) && !this._jsonConfiguration.get(type).isJsonObject()) {
            this.setJsonObject(type, defaultValue);
        }
        return this.isJsonNull(type) ? defaultValue : this._jsonConfiguration.get(type).getAsJsonObject();
    }

    public Config setJsonElement(String type, JsonElement newValue) {
        this._jsonConfiguration.add(type, newValue);
        this.save();
        return this;
    }

    public JsonElement getJsonElement(String type, JsonElement defaultValue) {
        if (this._jsonConfiguration == null) {
            this._jsonConfiguration = new JsonObject();
        }
        if (!this.isJsonNull(type) && !this._jsonConfiguration.get(type).isJsonPrimitive()) {
            this.setJsonElement(type, defaultValue);
        }
        return this.isJsonNull(type) ? defaultValue : this._jsonConfiguration.get(type).getAsJsonObject();
    }

    public Config setJsonObject(String type, JsonObject newValue) {
        this._jsonConfiguration.add(type, (JsonElement)newValue);
        this.save();
        return this;
    }

    public JsonArray getJsonArray(String type, JsonArray defaultValue) {
        if (this._jsonConfiguration == null) {
            this._jsonConfiguration = new JsonObject();
        }
        if (!this.isJsonNull(type) && !this._jsonConfiguration.get(type).isJsonArray()) {
            this.setJsonArray(type, defaultValue);
        }
        return this.isJsonNull(type) ? defaultValue : this._jsonConfiguration.get(type).getAsJsonArray();
    }

    public Config setJsonArray(String type, JsonArray newValue) {
        this._jsonConfiguration.add(type, (JsonElement)newValue);
        this.save();
        return this;
    }
}

