/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.config.parser;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import net.minecraft.class_155;
import org.apache.logging.log4j.Level;
import org.meteordev.starscript.Script;
import org.meteordev.starscript.Section;
import org.meteordev.starscript.StandardLib;
import org.meteordev.starscript.Starscript;
import org.meteordev.starscript.compiler.Compiler;
import org.meteordev.starscript.compiler.Parser;
import org.meteordev.starscript.utils.Error;
import org.meteordev.starscript.utils.StarscriptError;
import org.meteordev.starscript.value.Value;
import org.meteordev.starscript.value.ValueMap;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.info.Player;
import ru.kelcuprum.alinlib.info.World;

public class StarScript {
    public Starscript ss = new Starscript();
    public String lastExceptionRunSection;
    public String lastExceptionRun;
    public String lastError;
    public long lastExceptionRunSectionCheck = 0L;
    public long lastExceptionRunCheck = 0L;
    public long lastErrorCheck = 0L;

    public StarScript() {
        StandardLib.init((Starscript)this.ss);
        this.ss.set("minecraft", new ValueMap().set("version", class_155.method_16673().method_48019()).set("loader", AlinLib.MINECRAFT.method_1547()).set("fps", () -> Value.number((double)AlinLib.MINECRAFT.method_47599())).set("window", new ValueMap().set("width", () -> Value.number((double)AlinLib.MINECRAFT.method_22683().method_4489())).set("height", () -> Value.number((double)AlinLib.MINECRAFT.method_22683().method_4506())).set("scaled_width", () -> Value.number((double)AlinLib.MINECRAFT.method_22683().method_4486())).set("scaled_height", () -> Value.number((double)AlinLib.MINECRAFT.method_22683().method_4502())).set("fullscreen", () -> Value.bool((boolean)AlinLib.MINECRAFT.method_22683().method_4498())).set("vsync", () -> Value.bool((boolean)((Boolean)AlinLib.MINECRAFT.field_1690.method_42433().method_41753())))));
        this.ss.set("time", () -> Value.string((String)this.getTime()));
        this.ss.set("player", new ValueMap().set("name", () -> Value.string((String)Player.getName())).set("uuid", () -> Value.string((String)Player.getUUID())).set("profile_type", () -> Value.string((String)Player.getProfileType())).set("license", () -> Value.bool((boolean)Player.isLicenseAccount())).set("health", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? Player.getHealth() : 0.0))).set("health_max", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? Player.getMaxHealth() : 0.0))).set("health_percent", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? Player.getPercentHealth() : 0.0))).set("armor", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? Player.getArmor() : 0.0))).set("direction", () -> Value.string((String)(AlinLib.MINECRAFT.field_1724 != null ? Player.getDirection(false) : ""))).set("direction_symbol", () -> Value.string((String)(AlinLib.MINECRAFT.field_1724 != null ? Player.getDirection(true) : ""))).set("debug.direction", () -> Value.string((String)(AlinLib.MINECRAFT.field_1724 != null ? Player.getDebugDirection(false) : ""))).set("debug.direction_symbol", () -> Value.string((String)(AlinLib.MINECRAFT.field_1724 != null ? Player.getDebugDirection(true) : ""))).set("ping", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? (double)Player.getPing() : -1.0))).set("hunger", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? (double)Player.getHunger() : 0.0))).set("pos", new ValueMap().set("x", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? Player.getX() : 0.0))).set("y", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? Player.getY() : 0.0))).set("z", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? Player.getZ() : 0.0)))).set("item", () -> Value.string((String)(AlinLib.MINECRAFT.field_1724 != null ? Player.getItemName() : ""))).set("item_count", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? (double)Player.getItemCount() : 0.0))).set("xp", new ValueMap().set("level", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? (double)AlinLib.MINECRAFT.field_1724.field_7520 : 0.0))).set("progress", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? (double)AlinLib.MINECRAFT.field_1724.field_7510 : 0.0))).set("total", () -> Value.number((double)(AlinLib.MINECRAFT.field_1724 != null ? (double)AlinLib.MINECRAFT.field_1724.field_7495 : 0.0)))));
        this.ss.set("world", new ValueMap().set("name", () -> Value.string((String)(AlinLib.MINECRAFT.field_1687 != null ? World.getName() : ""))).set("time_type", () -> Value.string((String)(AlinLib.MINECRAFT.field_1687 != null ? World.getTimeType() : ""))).set("time_formatted", () -> Value.string((String)(AlinLib.MINECRAFT.field_1687 != null ? World.getFormattedTime() : ""))).set("time", () -> Value.number((double)(AlinLib.MINECRAFT.field_1687 != null ? (double)World.getTime() : -1.0))).set("day_time", () -> Value.number((double)(AlinLib.MINECRAFT.field_1687 != null ? (double)World.getTime() : -1.0))).set("days", () -> Value.number((double)(AlinLib.MINECRAFT.field_1687 != null ? (double)World.getDays() : -1.0))).set("difficulty", () -> Value.string((String)(AlinLib.MINECRAFT.field_1687 != null ? AlinLib.MINECRAFT.field_1687.method_8407().method_5463().getString() : ""))));
    }

    public String getTime() {
        Object clock;
        try {
            String strDateFormat = AlinLib.localization.getLocalization("date.time", false, false);
            SimpleDateFormat dateFormat = new SimpleDateFormat(strDateFormat);
            clock = dateFormat.format(System.currentTimeMillis());
            if (strDateFormat.contains("hh")) {
                clock = (String)clock + (new Date().getHours() >= 12 ? "pm" : "am");
            }
        }
        catch (IllegalArgumentException ex) {
            clock = "[It's not correct format for Java SimpleDateFormat]";
        }
        return clock;
    }

    public Script compile(String source) {
        Parser.Result result = Parser.parse((String)source);
        if (result.hasErrors()) {
            for (Error error : result.errors) {
                if (!Objects.equals(this.lastError, error.message) && System.currentTimeMillis() - this.lastErrorCheck > 500L) {
                    this.lastError = error.message;
                    AlinLib.LOG.log("[StarScript/Errors] " + error.message, Level.ERROR);
                }
                this.lastErrorCheck = System.currentTimeMillis();
            }
            return null;
        }
        if (this.lastError != null) {
            this.lastError = null;
        }
        return Compiler.compile((Parser.Result)result);
    }

    public Section runSection(Script script, StringBuilder sb) {
        try {
            if (this.lastExceptionRunSection != null) {
                this.lastExceptionRunSection = null;
            }
            return this.ss.run(script, sb);
        }
        catch (StarscriptError error) {
            if (!Objects.equals(this.lastExceptionRunSection, error.getLocalizedMessage()) && System.currentTimeMillis() - this.lastExceptionRunSectionCheck > 500L) {
                this.lastExceptionRunSection = error.getLocalizedMessage();
                AlinLib.LOG.log("[StarScript/runSection] " + error.getLocalizedMessage(), Level.ERROR);
            }
            this.lastExceptionRunSectionCheck = System.currentTimeMillis();
            return null;
        }
    }

    public String run(Script script, StringBuilder sb) {
        try {
            Section section = this.runSection(script, sb);
            if (this.lastExceptionRun != null) {
                this.lastExceptionRun = null;
            }
            return section == null ? "" : section.toString();
        }
        catch (Exception error) {
            if (!Objects.equals(this.lastExceptionRun, error.getLocalizedMessage()) && System.currentTimeMillis() - this.lastExceptionRunCheck > 500L) {
                this.lastExceptionRun = error.getLocalizedMessage();
                AlinLib.LOG.log("[StarScript/run] " + error.getLocalizedMessage(), Level.ERROR);
            }
            this.lastExceptionRunCheck = System.currentTimeMillis();
            return "[AlinLib] StarScript error occurred, please check the console";
        }
    }

    public String run(Script script) {
        return this.run(script, new StringBuilder());
    }
}

