/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.styles.AbstractStyle;
import ru.kelcuprum.alinlib.gui.styles.SafeStyle;

public class GuiUtils {
    public static final int DEFAULT_HEIGHT = 20;
    protected static Map<String, AbstractStyle> styles = new HashMap<String, AbstractStyle>();
    protected static List<String> stylesID = new ArrayList<String>();
    protected static AbstractStyle safeStyle = new SafeStyle();

    public static void drawCenteredString(class_332 guiGraphics, class_327 font, class_2561 component, int x, int y, int color, boolean shadow) {
        class_5481 formattedCharSequence = component.method_30937();
        guiGraphics.method_51430(font, formattedCharSequence, x - font.method_30880(formattedCharSequence) / 2, y, color, shadow);
    }

    public static boolean isDoesNotFit(class_2561 message, Number width, Number height) {
        int size = AlinLib.MINECRAFT.field_1772.method_27525((class_5348)message) + (height.intValue() - 8) * 2;
        return size > width.intValue();
    }

    public static int DEFAULT_WIDTH() {
        return class_310.method_1551().method_22683().method_4489() - ((AlinLib.bariumConfig.getBoolean("CONFIG_SCREEN.SMALL_PANEL_SIZE", false) ? 130 : 190) - 20);
    }

    public static class_2960 getResourceLocation(String path) {
        return class_2960.method_60656((String)path);
    }

    public static class_2960 getResourceLocation(String id, String path) {
        return class_2960.method_60655((String)id, (String)path);
    }

    public static void registerStyle(AbstractStyle style) {
        if (styles.get(style.id) == null) {
            stylesID.add(style.id);
        }
        styles.put(style.id, style);
        AlinLib.LOG.log(String.format("[Style] Registration of %s by id %s", style.name.getString(), style.id));
    }

    public static String[] getStylesName() {
        String[] list = new String[stylesID.size()];
        int i = 0;
        for (String id : stylesID) {
            list[i] = GuiUtils.styles.getOrDefault((Object)id, (AbstractStyle)GuiUtils.safeStyle).name.getString();
            ++i;
        }
        return list;
    }

    public static int getPositionOnStylesID(String name) {
        int i = 0;
        for (String id : GuiUtils.getStylesName()) {
            if (id.equals(name)) break;
            ++i;
        }
        return i;
    }

    public static AbstractStyle getStyleByName(String name) {
        AbstractStyle style = safeStyle;
        for (String id : stylesID) {
            AbstractStyle styleById = GuiUtils.getStyleByID(id);
            if (!Objects.equals(styleById.name.getString(), name)) continue;
            style = styleById;
        }
        return style;
    }

    public static AbstractStyle getStyleByID(String id) {
        return styles.getOrDefault(id, safeStyle);
    }

    public static AbstractStyle getSelected() {
        String id = AlinLib.bariumConfig.getString("DEFAULT_DESIGN_TYPE", stylesID.isEmpty() ? GuiUtils.safeStyle.id : stylesID.get(0));
        return GuiUtils.getStyleByID(id);
    }

    public static int interpolate(int color1, int color2, float progress) {
        int a1 = (color1 & 0xFF000000) >>> 24;
        int r1 = (color1 & 0xFF0000) >>> 16;
        int g1 = (color1 & 0xFF00) >>> 8;
        int b1 = color1 & 0xFF;
        int a2 = (color2 & 0xFF000000) >>> 24;
        int r2 = (color2 & 0xFF0000) >>> 16;
        int g2 = (color2 & 0xFF00) >>> 8;
        int b2 = color2 & 0xFF;
        float progress2 = 1.0f - progress;
        int newA = GuiUtils.clip((int)((float)a1 * progress2 + (float)a2 * progress));
        int newR = GuiUtils.clip((int)((float)r1 * progress2 + (float)r2 * progress));
        int newG = GuiUtils.clip((int)((float)g1 * progress2 + (float)g2 * progress));
        int newB = GuiUtils.clip((int)((float)b1 * progress2 + (float)b2 * progress));
        return (newA << 24) + (newR << 16) + (newG << 8) + newB;
    }

    public static int clip(int num) {
        return num <= 0 ? 0 : Math.min(num, 255);
    }
}

