/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class GsonHelper {
    public static String getStringInJSON(String path, JsonObject parse) {
        return GsonHelper.getStringInJSON(path, parse, null);
    }

    public static String getStringInJSON(String path, JsonObject parse, String defResp) {
        if (GsonHelper.jsonElementIsNull(path, parse)) {
            return defResp;
        }
        String[] keys = path.split("\\.");
        JsonObject jsonObject = parse;
        for (String key : keys) {
            if (!jsonObject.has(key)) continue;
            JsonElement json = jsonObject.get(key);
            if (json.isJsonObject()) {
                jsonObject = (JsonObject)json;
                continue;
            }
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isString() || json.getAsString().isBlank()) continue;
            return json.getAsString();
        }
        return defResp;
    }

    public static Number getNumberInJSON(String path, JsonObject parse) {
        return GsonHelper.getNumberInJSON(path, parse, null);
    }

    public static Number getNumberInJSON(String path, JsonObject parse, Number defResp) {
        if (GsonHelper.jsonElementIsNull(path, parse)) {
            return defResp;
        }
        String[] keys = path.split("\\.");
        JsonObject jsonObject = parse;
        for (String key : keys) {
            if (!jsonObject.has(key)) continue;
            JsonElement json = jsonObject.get(key);
            if (json.isJsonObject()) {
                jsonObject = (JsonObject)json;
                continue;
            }
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isNumber()) continue;
            return json.getAsNumber();
        }
        return defResp;
    }

    public static JsonElement getJsonElementFromObject(String path, JsonObject parse) {
        return GsonHelper.getJsonElementFromObject(path, parse, null);
    }

    public static JsonElement getJsonElementFromObject(String path, JsonObject parse, JsonElement defResp) {
        if (GsonHelper.jsonElementIsNull(path, parse)) {
            return defResp;
        }
        String[] keys = path.split("\\.");
        JsonObject jsonObject = parse;
        for (String key : keys) {
            if (!jsonObject.has(key)) continue;
            JsonElement json = jsonObject.get(key);
            if (json.isJsonObject()) {
                jsonObject = (JsonObject)json;
                continue;
            }
            return json;
        }
        return defResp;
    }

    public static boolean getBooleanInJSON(String path, JsonObject parse, boolean defResp) {
        if (GsonHelper.jsonElementIsNull(path, parse)) {
            return defResp;
        }
        String[] keys = path.split("\\.");
        JsonObject jsonObject = parse;
        for (String key : keys) {
            if (!jsonObject.has(key)) continue;
            JsonElement json = jsonObject.get(key);
            if (json.isJsonObject()) {
                jsonObject = (JsonObject)json;
                continue;
            }
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isBoolean()) continue;
            return json.getAsBoolean();
        }
        return defResp;
    }

    public static boolean jsonElementIsNull(String path, JsonObject parse) {
        String[] keys = path.split("\\.");
        JsonObject jsonObject = parse;
        for (String key : keys) {
            if (!jsonObject.has(key)) continue;
            JsonElement json = jsonObject.get(key);
            if (json.isJsonObject() && !keys[keys.length - 1].equals(key)) {
                jsonObject = (JsonObject)json;
                continue;
            }
            if (json.isJsonNull()) continue;
            return false;
        }
        return true;
    }
}

